/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.security;

import java.util.Random;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class SecureRandom
extends Random {
    private static SecureRandom rand = new SecureRandom(new DigestRandomGenerator(new SHA1Digest()));
    protected RandomGenerator generator;

    public SecureRandom() {
        super(0L);
        this.generator = new DigestRandomGenerator(new SHA1Digest());
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] inSeed) {
        super(0L);
        this.generator = new DigestRandomGenerator(new SHA1Digest());
        this.setSeed(inSeed);
    }

    protected SecureRandom(RandomGenerator generator) {
        super(0L);
        this.generator = generator;
    }

    public static SecureRandom getInstance(String algorithm) {
        if (algorithm.equals("SHA1PRNG")) {
            return new SecureRandom(new DigestRandomGenerator(new SHA1Digest()));
        }
        return new SecureRandom();
    }

    public static SecureRandom getInstance(String algorithm, String provider) {
        return SecureRandom.getInstance(algorithm);
    }

    public static byte[] getSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        rand.setSeed(System.currentTimeMillis());
        rand.nextBytes(rv);
        return rv;
    }

    public byte[] generateSeed(int numBytes) {
        byte[] rv = new byte[numBytes];
        this.nextBytes(rv);
        return rv;
    }

    public void setSeed(byte[] inSeed) {
        this.generator.addSeedMaterial(inSeed);
    }

    public void nextBytes(byte[] bytes) {
        this.generator.nextBytes(bytes);
    }

    public void setSeed(long rSeed) {
        if (rSeed != 0L) {
            this.generator.addSeedMaterial(rSeed);
        }
    }

    public int nextInt() {
        byte[] intBytes = new byte[4];
        this.nextBytes(intBytes);
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) + (intBytes[i] & 0xFF);
        }
        return result;
    }

    protected final int next(int numBits) {
        int size = (numBits + 7) / 8;
        byte[] bytes = new byte[size];
        this.nextBytes(bytes);
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result & (1 << numBits) - 1;
    }
}

