/*
 * Decompiled with CFR 0.152.
 */
package FreeAuth;

import FreeAuth.Base64;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.security.SecureRandom;

public class AES_PBE_BC {
    private static int iterationCount = 25;
    private PaddedBufferedBlockCipher cipher;
    private KeyParameter keyParam;
    private ParametersWithIV params;
    private byte[] salt = new byte[8];
    private int saltset = 0;

    public AES_PBE_BC(char[] pass, byte[] newSalt) {
        if (newSalt.length >= 8) {
            this.saltset = 1;
            for (int i = 0; i < 8; ++i) {
                this.salt[i] = newSalt[i];
            }
            System.out.println("Setting salt to: " + new String(this.salt));
        }
        try {
            this.init(pass);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public void setIV(byte[] iv) {
        this.params.iv = iv;
    }

    public byte[] getIV() {
        return this.params.iv;
    }

    public byte[] getKey() {
        return this.keyParam.getKey();
    }

    public void setKey(char[] pass) {
        byte[] tmpB = new byte[pass.length];
        for (int i = 0; i < pass.length; ++i) {
            tmpB[i] = (byte)pass[i];
        }
        this.keyParam.setKey(tmpB);
    }

    public byte[] getSalt() {
        if (this.saltset == 0) {
            System.out.println("Generating new salt.");
            SecureRandom sr = new SecureRandom();
            int j = 0;
            for (int i = 0; i < 8; ++i) {
                do {
                    if ((j = sr.nextInt() * 4096) >= 0) continue;
                    j *= -1;
                } while ((j %= 127) < 32 | j > 126);
                this.salt[i] = (byte)j;
            }
            this.saltset = 1;
            System.out.println("New salt is: " + new String(this.salt));
        }
        return this.salt;
    }

    private void init(char[] pass) throws Exception {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        if (this.saltset == 0) {
            this.getSalt();
        }
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes(pass), this.salt, iterationCount);
        this.params = (ParametersWithIV)((PBEParametersGenerator)generator).generateDerivedParameters(128, 128);
        this.keyParam = (KeyParameter)this.params.getParameters();
        this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESFastEngine()), new PKCS7Padding());
    }

    public String encrypt(String plainText) throws Exception {
        this.cipher.init(true, this.keyParam);
        byte[] plainTextBytes = plainText.getBytes("UTF8");
        byte[] cipherTextBytes = new byte[this.cipher.getOutputSize(plainTextBytes.length)];
        int outputLen = this.cipher.processBytes(plainTextBytes, 0, plainTextBytes.length, cipherTextBytes, 0);
        this.cipher.doFinal(cipherTextBytes, outputLen);
        return new String(Base64.encode(cipherTextBytes));
    }

    public String decrypt(String cipherTextB64) throws Exception {
        this.cipher.init(false, this.keyParam);
        byte[] cipherTextBytes = Base64.decode(cipherTextB64);
        byte[] plainTextBytes = new byte[this.cipher.getOutputSize(cipherTextBytes.length)];
        int outputLen = this.cipher.processBytes(cipherTextBytes, 0, cipherTextBytes.length, plainTextBytes, 0);
        this.cipher.doFinal(plainTextBytes, outputLen);
        return new String(plainTextBytes, "UTF8");
    }
}

