/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Jul 24 10:35:42 BST 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <qsplitter.h>

#include "ebqt.h"
#include "ebqtmainwin.h"

int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	
	// set up i18n...
	QTranslator tor(0);
	// set the location where your .qm files are in load() below as the
	// last parameter instead of "."
	// for development, use "/" to use the english original as
	// .qm files are stored in the base project directory.
	tor.load( QString("ebqt.") + QTextCodec::locale(), "." );
	a.installTranslator(&tor);
	
	// get a main window...
	QSplitter * top = new QSplitter(Qt::Horizontal, 0, "topSplitter");
	new EbQtMainWin(top, "mainwin");
	a.setMainWidget(top);
	top->show();
	
	// ...and run until all windows are closed
	a.connect(&a, SIGNAL(lastWindowClosed()), SLOT(quit()));
	return a.exec();
}
