/***************************************************************************
                          ebqttrayicon.h  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2002-2004 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTTRAYICON_H
#define EBQTTRAYICON_H

#include <qwidget.h>
#include <qlabel.h>

#ifndef Q_WS_X11
#error "Sorry, the EbQt systray icon is only supported on X11"
#endif

/**
  * a systray/notification area icon for EbQt, using the NET_SYSTEM_TRAY
  * standard protocol
  *
  * @author Chris Boyle
  */
class EbQtTrayIcon : public QLabel  {
	Q_OBJECT

public: 
	EbQtTrayIcon(QWidget * parent = 0, const char * name = 0);
	~EbQtTrayIcon();
	void requestDock();

signals:
	void clicked(const QPoint & where);
	void rightClicked(const QPoint & where);

protected:
	void mousePressEvent(QMouseEvent * e);
	void enterEvent(QEvent * e);
//	bool x11Event(XEvent * e);

private:
	QWidget * mainWin;
};

#endif
