/***************************************************************************
                          ebqttrayicon.cpp  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2002-2004 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include "ebqttrayicon.h"

// NETWM system tray icons: spec at
// http://www.freedesktop.org/standards/systemtray/systemtray-spec.html

#define SYSTEM_TRAY_REQUEST_DOCK    0
#define SYSTEM_TRAY_BEGIN_MESSAGE   1
#define SYSTEM_TRAY_CANCEL_MESSAGE  2
#define _NET_WM_STATE_REMOVE	0
#define _NET_WM_STATE_ADD	1
#define _NET_WM_STATE_TOGGLE	2
#include <X11/Xlib.h>
#include <X11/Xatom.h>
// this is for the big honking kludge (see enterEvent)
const int XFocusOut = FocusOut;
const int XFocusIn = FocusIn;
#undef FocusOut
#undef FocusIn
extern Time qt_x_time;

#include <qapplication.h>
#include <qevent.h>

EbQtTrayIcon::EbQtTrayIcon(QWidget * mainWin, const char * name) :
	QLabel(mainWin, name, Qt::WType_TopLevel | Qt::WStyle_Customize
		| Qt::WStyle_NoBorder),
	// not Qt::WX11BypassWM since that hides from KDE too much
	mainWin(mainWin)
{
	setScaledContents(TRUE);
	setFixedSize(22,22);
	
	// just in case it doesn't dock, hide it completely
	move(-32,-32);
	Display * dpy = qt_xdisplay();
	XEvent ev;
	memset(&ev, 0, sizeof(ev));
	ev.type = ClientMessage;
	ev.xclient.display = dpy;
	ev.xclient.window = qt_xrootwin();
	ev.xclient.message_type =
		XInternAtom(dpy, "_NET_WM_STATE", False);
	ev.xclient.format = 32;
	ev.xclient.data.l[0] = _NET_WM_STATE_ADD;
	ev.xclient.data.l[1] =
		XInternAtom(dpy, "_NET_WM_STATE_SKIP_TASKBAR", False);
	ev.xclient.data.l[2] = 0;
	XSendEvent(dpy, qt_xrootwin(), False, NoEventMask, &ev);
}

EbQtTrayIcon::~EbQtTrayIcon()
{
}

void EbQtTrayIcon::requestDock()
{
	Display * dpy = qt_xdisplay();
	int scr = qt_xscreen();
	Window w = winId();
	Window m = mainWin ? mainWin->winId() : w;
	
	// XEmbed tags
	unsigned long buf[2];
	buf[0] = 0;  // version
	buf[1] = 0;  // mapped
	XChangeProperty(dpy, w,  // XEmbed might need this
		XInternAtom(dpy, "_XEMBED_INFO", False),
		XA_WINDOW, 32, PropModeReplace,
		(unsigned char *)buf, 1);
	
	XChangeProperty(dpy, w,  // KDE 2, 3
		XInternAtom(dpy, "_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", False),
		XA_WINDOW, 32, PropModeReplace, (unsigned char *) &m, 1);
	XChangeProperty(dpy, w,  // KDE 1 (well, remote X11 for example?)
		XInternAtom(dpy, "KWM_DOCKWINDOW", False),
		XA_WINDOW, 32, PropModeReplace, (unsigned char *) &m, 1);
		
	// find the systray
	char selection[32];
	snprintf(selection, sizeof(selection), "_NET_SYSTEM_TRAY_S%d", scr);
	// non-zero indicates there is one on this screen
	Window systray =
		XGetSelectionOwner(dpy, XInternAtom(dpy, selection, False));
	if (! systray)
		return;
	XEvent ev;
	memset(&ev, 0, sizeof(ev));
	ev.type = ClientMessage;
	ev.xclient.display = dpy;
	ev.xclient.window = systray;
	ev.xclient.message_type =
		XInternAtom(dpy, "_NET_SYSTEM_TRAY_OPCODE", False);
	ev.xclient.format = 32;
	ev.xclient.data.l[0] = CurrentTime;
	ev.xclient.data.l[1] = SYSTEM_TRAY_REQUEST_DOCK;
	ev.xclient.data.l[2] = w;
	ev.xclient.data.l[3] = 0;
	ev.xclient.data.l[4] = 0;
	
	// TODO: trap errors?
	XSendEvent(dpy, systray, False, NoEventMask, &ev);
	XSync(dpy, False);
	
	show();
}

void EbQtTrayIcon::mousePressEvent(QMouseEvent * e)
{
	if (e->button() == Qt::LeftButton) {
		emit(clicked(e->globalPos()));
		e->accept();
	} else if (e->button() == Qt::RightButton) {
		emit(rightClicked(e->globalPos()));
		e->accept();
	} else {
		e->ignore();
	}
}

//bool EbQtTrayIcon::x11Event(XEvent * e)
//{
//	if (e->type == ClientMessage && e->xclient.message_type ==
//		XInternAtom(e->xclient.display, "_XEMBED", False)) {
//		qDebug("XCM type %ld received", e->xclient.data.l[1]);
//	}
//	return FALSE;
//}

void EbQtTrayIcon::enterEvent(QEvent *)
{
//	QFocusEvent fe(QEvent::FocusIn);
//	qApp->notify(this, &fe);

	// FIXME: WHY OH WHY doesn't the above work?
	// ...since the below is a big honking kludge
	// (but hey, it works for KSystemTray...)

	if (! qApp->focusWidget()) {
		XEvent ev;
		memset(&ev, 0, sizeof(ev));
		ev.type = XFocusIn;
		ev.xfocus.display = qt_xdisplay();
		ev.xfocus.window = winId();
		ev.xfocus.mode = NotifyNormal;
		ev.xfocus.detail = NotifyAncestor;
		Time time = qt_x_time;
		qt_x_time = 1;
		qApp->x11ProcessEvent(&ev);
		qt_x_time = time;
	}
}

