/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void EbQtTextEdit::init()
{
	defaultColour = textEdit->color();
	defaultPointSz = textEdit->pointSize();
	pointSzStep =
		(int)(((double)defaultPointSz)
		      * ((double)EBQT_CONV_FONT_STEP_SIZE));
	
#if (QT_VERSION >= 0x030100)
	textEdit->setWrapPolicy(QTextEdit::AtWordOrDocumentBoundary);
	// save the cook function some effort, and more importantly, make
	// the thing look consistent (Qt 3.0 can't turn this off)
	textEdit->setAutoFormatting(QTextEdit::AutoAll & ~ QTextEdit::AutoBulletList);
	showFont(textEdit->currentFont());
#else
	showFont(textEdit->font());  // old name
#endif
}

void EbQtTextEdit::showFont( const QFont & font )
{
	bold->blockSignals(TRUE);
	bold->setOn(font.bold());
	bold->blockSignals(FALSE);
	italic->blockSignals(TRUE);
	italic->setOn(font.italic());
	italic->blockSignals(FALSE);
	underline->blockSignals(TRUE);
	underline->setOn(font.underline());
	underline->blockSignals(FALSE);
	
	fontSzUp->blockSignals(TRUE);
	fontSzDown->blockSignals(TRUE);
	if (rawMode->isOn()) {
		fontSzUp->setOn(FALSE);
		fontSzUp->setEnabled(FALSE);
		fontSzDown->setOn(FALSE);
		fontSzDown->setEnabled(FALSE);
	} else {
		fontSzDown->setOn(font.pointSize() < defaultPointSz);
		fontSzDown->setEnabled(font.pointSize() >
				       (defaultPointSz + EBQT_CONV_FONT_MIN_STEPS * pointSzStep));
		fontSzUp->setOn(font.pointSize() > defaultPointSz);
		fontSzUp->setEnabled(font.pointSize() <
				     (defaultPointSz + EBQT_CONV_FONT_MAX_STEPS * pointSzStep));
	}
	fontSzUp->blockSignals(FALSE);
	fontSzDown->blockSignals(FALSE);
}

void EbQtTextEdit::setFontSzDown( bool )
{
	textEdit->setPointSize(textEdit->pointSize() - pointSzStep);
}

void EbQtTextEdit::setFontSzUp( bool )
{
	textEdit->setPointSize(textEdit->pointSize() + pointSzStep);
}

void EbQtTextEdit::setColour( bool on )
{
	QColor newColour;
	if (on && (newColour = QColorDialog::getColor(
		textEdit->color(), this))
		!= textEdit->color()) {
			textEdit->setColor(newColour);
			fontColour->setPaletteBackgroundColor(newColour);
		} else {
			textEdit->setColor(defaultColour);
			fontColour->blockSignals(TRUE);
			fontColour->setOn(FALSE);
			fontColour->unsetPalette();
			fontColour->blockSignals(FALSE);
		}
	}

void EbQtTextEdit::setRawMode( bool on )
{
	rawMode->blockSignals(TRUE);
	rawMode->setOn(on);
	rawMode->blockSignals(FALSE);
	bold->setEnabled(! on);
	italic->setEnabled(! on);
	underline->setEnabled(! on);
	fontSzDown->setEnabled(! on);
	fontSzUp->setEnabled(! on);
	fontColour->setEnabled(! on);
	// always off for now
	//insertSmiley->setEnabled(! on);
	
	QString prevText = on
			   ? cook(textEdit->text())
			   : textEdit->text();
	textEdit->clear();  // seems necessary to allow switch
	textEdit->setTextFormat(on
				? QTextEdit::PlainText
				: QTextEdit::RichText);
	textEdit->setText(prevText);
	
	showFont(QFont());
}

QString EbQtTextEdit::cook( QString text )
{
	// the one ugly bit of wysiwyg:
	// Qt includes _lots_ of unwanted html if you turn on rich text
	
	// FIXME: all the regexps in this function could probably be a _lot_
	// faster, all tweaking suggestions welcome :-)
	
	// first kill the head and tail
	text = text.replace(QRegExp("^.*<body(?: [^>]*)?>\\s*(?:<p>)?", FALSE), "")
	       .replace(QRegExp("(?:<br(?: /)?>)?(?:</p>)?\\s*</body>.*$", FALSE), "");
	
	// text is invalid at this point, typically:
	//   foo </p> <p> bar </p> <p> baz
	// but it's much easier to parse :-)
	
	// bulleted lists will look nice if you comment this out, but they're
	// not supported by most clients, so this replaces them with text
	// ...and I know Qt 3.1 lets you turn off the textedit's auto bullets,
	// but I want Qt 3.0 compatibility
	text.replace(QRegExp("<ul(?: [^>]+)?>", FALSE), "");
	text.replace(QRegExp("</ul>", FALSE), "");
	QRegExp listItem("<(li|div)>([^\n]+)</\\1>", FALSE);
	int pos=0;
	while(pos<(int)(text.length())) {
		pos=listItem.search(text, pos);
		if (pos < 0) break;
		text.replace(pos, listItem.matchedLength(),
			     QString(listItem.cap(1) == "li" ? "\t* " : "\t")
			     + listItem.cap(2)
			     + "<br />");
		pos += listItem.cap(2).length()
		       + (listItem.cap(1) == "li" ? 2 : 1);
	}
	
	// we want to send _any_ forms of newline as plain old '\n'
	text.replace(QRegExp("</p>\\s*<p>", FALSE), "\n");
	text.replace(QRegExp("<br(?: /)?>\n?", FALSE), "\n");
	
	// if _only_ QTextEdit had a frickin' simple html mode, not just
	// this weird style stuff!
	QRegExp spanRe("<span style=\"([^\"]*)\">([^<]*)</span>", FALSE);
	while(spanRe.search(text) >= 0) {
		QStringList styles =
			QStringList::split(QRegExp(";\\s*"), spanRe.cap(1));
		QStringList tags;
		QString tmp;
		for (QStringList::Iterator si = styles.begin(); si != styles.end(); si++) {
			if ((*si).startsWith("font-weight:")
				&& (tmp = (*si)).replace(0, 12, "").toUInt() > 400)
				tags += "b";  // results in 600 here
			else if ((*si) == "font-style:italic")
				tags += "i";
			else if ((*si) == "text-decoration:underline")
				tags += "u";
			else if ((*si).startsWith("color:")) {
				tags += "font color=\"" + ((*si).replace(0, 6, "")) + "\"";
			} else if ((*si).startsWith("font-size:")) {
				int sz = (tmp = (*si)).replace(0, 10, "")
					 .replace(QRegExp("pt$"), "")
					 .toUInt() - defaultPointSz;
				sz /= pointSzStep;
				if (sz != 0) {
					tags += QString("font size=\"")
						+ (sz > 0 ? "+" : "")
						+ QString::number(sz) + "\"";
				}
			} else if ((*si) != "font-weight:400")
				// (which gets thrown in like it's going out of fashion...)
				qWarning("conv: ignoring unknown style %s", (*si).ascii());
		}
		QString newSpan = spanRe.cap(2);
		for (QStringList::Iterator ti = tags.begin(); ti != tags.end(); ti++) {
			QString endTag = *ti; endTag.replace(QRegExp("\\s.*"), "");
			newSpan = QString("<%1>%2</%3>")
				  .arg(*ti).arg(newSpan).arg(endTag);
		}
		text.replace(spanRe.pos(), spanRe.matchedLength(), newSpan);
	}
	
	// sometimes it repeats itself rather than nesting tags
	QRegExp futility("</(b|i|u)><\\1>", FALSE);
	while (futility.search(text) >= 0) {
		text.replace(futility.pos(), futility.matchedLength(), "");
	}
	
	// and this is a little section I'll call "overkill"...
	text.replace(QRegExp("&quot;", FALSE), "\"");
	
	return text;
}

QString EbQtTextEdit::text()
{
	return cook(textEdit->text());
}

void EbQtTextEdit::setText( const QString & text )
{
	textEdit->setText(text);
}

void EbQtTextEdit::clear()
{
	textEdit->clear();
}
