/***************************************************************************
                          ebqtsocket.h  -  description
                             -------------------
    begin                : Thu Jul 25 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTSOCKET_H
#define EBQTSOCKET_H

#include "ebqt.h"
#include "ebqtcommand.h"

class QProcess;

#include <qsocket.h>
#include <qvaluelist.h>

/**
  * EbQtSocket handles non-blocking reads and writes of commands
  *
  * @author Chris Boyle
  */

class EbQtSocket : public QObject
{
	Q_OBJECT

public:
	/** constructor */
	EbQtSocket(QObject * parent = 0, const char * name = 0);
	/** destructor */
	~EbQtSocket();
	/** how many incoming commands are waiting for processing */
	uint count() const { return queue.count(); }
	/** whether the incoming queue is empty */
	bool isEmpty() const { return queue.isEmpty(); }
	/** pops off the first item in the incoming queue */
	EbQtSocket &operator>>(EbQtCommand &command);
	/** writes a command (may return before the command is actually written) */
	EbQtSocket &operator<<(const EbQtCommand &command);
	QHostAddress address() { return sock->address(); }
	QHostAddress peerAddress() { return sock->peerAddress(); }
	Q_UINT16 port() { return sock->port(); }
	Q_UINT16 peerPort() { return sock->peerPort(); }
	QSocket::State state() { return sock->state(); }
	/** disconnect */
	void close();
	bool hasProcess() { return launchedCore != NULL; }

public slots:
	/** connect :-) */
	void connectToHost(const QString & host, const QByteArray & cookie,
		Q_UINT16 port = EBQT_DEFAULT_PORT);
	
	bool launchAndConnect(const QString & cmd);
	void killLaunchedCore();

signals:
	/** emitted when a new (complete) command has arrived, but only emitted
	  * once between reads */
	void gotNewCommand();
	
	/** same as in QSocket */
	void hostFound();
	/** same as in QSocket */
	void connected();
	/** same as in QSocket */
	void connectionClosed();
	/** same as in QSocket */
	void delayedCloseFinished();
	/** same as in QSocket */
	void error(int);

private slots:
	/** Reads any data from the socket's buffer, coping with arbitrary
	  * fragmentation of commands across packets. */
	void getNewBytes();
	/** sends any autoresponse (i.e. the cookie) and passes the buck */
	void gotConnected();

private:
	/** the socket */
	QSocket * sock;
	QProcess * launchedCore;
	/** complete commands we've read from the socket */
	QValueList<EbQtCommand> queue;
	/** whether we've sent a signal since the last read */
	bool sigSent;
	/** the cookie */
	QByteArray autoResp;
	/** deals with having just got an incoming command */
	void gotOne(const EbQtCommand & command);
};

#endif
