/***************************************************************************
                          ebqtservice.h  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTSERVICE_H
#define EBQTSERVICE_H

#include <qobject.h>
#include <qdict.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qcolor.h>
#include <qpixmap.h>

#include "ebqt.h"
#include "ebqtaccount.h"
#include "ebqtlocalaccount.h"

/**
  * EbQtService is an Everybuddy service, identifying a server and protocol
  * The service name is QObject::name()
  *
  * @author Chris Boyle
  */
class EbQtService : public QObject  {
	Q_OBJECT

public: 
	EbQtService(QObject * parent, const QString & name);
	~EbQtService();
	QString name() const { return serviceName; }
	
	/** the local accounts using this service */
	QDictIterator<EbQtLocalAccount> localAccounts() {
		return QDictIterator<EbQtLocalAccount>(lclAcctDict); }
	EbQtLocalAccount * localAccount(const QString & name) {
		return lclAcctDict[name]; }
	void addLocal(EbQtLocalAccount * l) { lclAcctDict.insert(l->name(), l); }
	void removeLocal(const QString & name) { lclAcctDict.remove(name); }
	
	/** the possible states of accounts on this service */
	QStringList states;
	/** things that can be done to buddies on this service (e.g. IRC whois) */
	QStringList buddyActions;
	/** things that can be done to groupchats on this service (e.g. set topic) */
	QStringList groupChatActions;
	/** things that can be done to users in groupchats on this service
	  * (e.g. give ops) */
	QStringList groupUserActions;
	
	/** can we do offline messaging? */
	bool canOffline()	const { return (caps & 1); }
	/** can we do group chats? */
	bool canGroupChat()	const { return (caps & 2); }
	/** is the name of a group chat significant? */
	bool hasNamedChats()	const { return (caps & 4); }
	
	const QColor & colour() const { return svcColour; }
	
	QPixmap pixmap(unsigned int w, unsigned int h, bool shade = false) const;
	static QPixmap drawPixmap(QColor fill, unsigned int w, unsigned int h,
		bool shade = FALSE);

public slots:
	void setName(const QString & name) { serviceName = name;
		QObject::setName(QString("service %1").arg(name)); }
	/** set capability flags */
	void setCaps(unsigned int caps) { this->caps = caps; }
	/** set colour */
	void setColour(const QColor & svcColour) { this->svcColour = svcColour; }

private:
	QString serviceName;
	QDict<EbQtLocalAccount> lclAcctDict;
	/** capability flags as set by setCaps() */
	unsigned int caps;
	/** the colour representing this service; currently appears in
	  * blobs beside accounts...
	  * this is how we spell it in .uk, live with it. ;-) */
	QColor svcColour;
};

#endif
