/***************************************************************************
                          ebqtservice.cpp  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>
#include <qpalette.h>
#include <qapplication.h>
#include <qbitmap.h>

#include "ebqtservice.h"

// no, this isn't some unfinished early version...
// most stuff in this class is simple and happens in the header file

EbQtService::EbQtService(QObject * parent, const QString & name) :
	QObject(parent),
	caps(0),
	svcColour(QApplication::palette().active().base())
{
	setName(name);
	lclAcctDict.setAutoDelete(TRUE);
}

EbQtService::~EbQtService()
{
	lclAcctDict.clear();  // ensure deletion
}

QPixmap EbQtService::pixmap(unsigned int w, unsigned int h, bool shade) const
{
	// TODO: cache?
	return drawPixmap(svcColour, w, h, shade);
}

// static
QPixmap EbQtService::drawPixmap(QColor fill, unsigned int w, unsigned int h, bool shade)
{
	QColorGroup cg = QApplication::palette().active();
	QColor	line = cg.foreground(),
		// "should have good contrast with base" (e.g. black)
		bg = cg.base(); // outside shape
	QPixmap blob(w,h);
	blob.fill(bg);  // listview bg colour
	QPainter p(&blob);
	if (shade) {
		int h,s,v;
		fill.hsv(&h,&s,&v);
		s /= 3;  // desaturate, i.e. go towards grey
		v = 255 - ((255-v)*4/5);  // go away from black a bit to compensate
		fill.setHsv(h,s,v);
	}
	
	/*
	// circle
	p.setBrush(fill);
	p.setPen(line);
	p.drawEllipse(blob.width()/6, blob.height()/6,
		(2*blob.width())/3, (2*blob.height())/3);
	*/
	
	// hexagon, 1 corner at 0 deg, brightest in 0-60 deg, darkest opposite
	// construct the shape to span 3/4 of the smaller dimension
	int	tw = blob.width(),
		th = blob.height(),
		cx = tw/2,
		cy = th/2,
		rw  = ((tw > th) ? th : tw)*3/8,
		rh  = rw/2;
	QPointArray hexagon(6);
	hexagon.setPoint(0, cx,      cy-rw);
	hexagon.setPoint(1, cx+rw-1, cy-rh);
	hexagon.setPoint(2, cx+rw-1, cy+rh);
	hexagon.setPoint(3, cx,      cy+rw);
	hexagon.setPoint(4, cx-rw,   cy+rh);
	hexagon.setPoint(5, cx-rw,   cy-rh);

	// filled triangles of the various colours
	if (fill.isValid()) {
		//fill = fill.light(130);
		QPointArray triangle(3);
		for (int i=5; i>=0; i--) {
			triangle.setPoint(0, cx, cy);
			triangle.setPoint(1, hexagon.point(i));
			triangle.setPoint(2, i == 5 ? hexagon.point(0)
				: hexagon.point(i+1));
			QColor segColour = fill.dark(i<3 ? 60 + 30*i : 240 - 30*i);
			p.setPen(segColour);
			p.setBrush(segColour);
			p.drawPolygon(triangle);
		}
	}

	// the outline of the hexagon itself
	p.setPen(line);
	p.setBrush(Qt::NoBrush);
	p.drawPolygon(hexagon);
	
	// transparency is important for selection and dragging
	blob.setMask(blob.createHeuristicMask());
	return blob;
}
