/***************************************************************************
                          ebqtprefpage.h  -  description
                             -------------------
    begin                : Mon Jan 6 2003
    copyright            : (C) 2002-2004 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTPREFPAGE_H
#define EBQTPREFPAGE_H

class QVBoxLayout;
class QGridLayout;
class QSpacerItem;
class QTabWidget;
class QScrollView;
class QVBox;
class QPushButton;
class QLabel;

#include <qwidget.h>
#include <qdict.h>
#include <qpixmap.h>

class EbQtService;

/**
  * EbQtPrefPage is a pref page, with components and/or subpages
  *
  * @author Chris Boyle
  */
class EbQtPrefPage : public QWidget  {
	Q_OBJECT

public: 
	EbQtPrefPage(QWidget *parent=0, const char *name=0,
		QDict<EbQtService> * allServices = 0);
	~EbQtPrefPage();

	QPixmap pixmap() const { return svcPixmap; }

public slots:
	virtual void setCaption(QString caption);
	void addComponent(const QString & type, const QString & name,
		const QString & title, const QString & value);
	void addOptionData(const QString & name, const QStringList & options);
	void addSubPage(EbQtPrefPage * page);
	
	void clearComponents();
	void clearSubPages();
	void clear() { clearComponents(); clearSubPages(); }
	
	/** refresh this page and all its children, recursively */
	void refresh() { emit(wantsRefresh(this)); }
	/** transmit settings for this page and all its children, recursively */
	void apply();
	/** "apply" button is actually this */
	void applyThenRefresh() { apply(); emit(wantsSave()); refresh(); }

	void selectAnySubpage(const QString & name);

signals:
	void captionChanged(const QString & caption, EbQtPrefPage * page);
	void buttonPressed(const QString & name, EbQtPrefPage * page);
	
	void wantsRefresh(EbQtPrefPage * page);
	void wantsValueSet(const QString & name, const QString & value,
		EbQtPrefPage * page);

	/** emitted by a top-level page after recursive apply, before recursive refresh */
	void wantsSave();

	void subPageSelected(EbQtPrefPage * subpage, EbQtPrefPage * page);

protected:
	void showEvent(QShowEvent * e);

private slots:
	void changeSubPageCaption(const QString & caption, EbQtPrefPage * page);
	void pressedButton();
	void setSubPage(QWidget * page) { prevSubPage = page->name();
		emit(subPageSelected((EbQtPrefPage *) page, this)); }
	void updateEmpty();

private:
	QVBoxLayout * layout;
	
	QScrollView	* componentView;	// a view...
	QWidget		* componentBox;		// of a box...
	QVBoxLayout	* componentLayout;	// with some components
	QLabel		* emptyLabel;		// hint when page is empty
	int row;
	
	QTabWidget * tabs;
	
	QDict<EbQtService> * allServices;
	QPixmap svcPixmap;
	
	QDict<QWidget> components;

	QPushButton * applyBtn;
	QPushButton * revertBtn;
	
	// this is for a bug that caused subpages to become blank on revert
	// until you switch away and back... very odd
	// update: also maintains selection across refreshes (which delete everything)
	QString prevSubPage;
};

#endif

