/***************************************************************************
                                ebqtmainwin.h
                             -------------------
    begin                : Wed Jul 24 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTMAINWIN_H
#define EBQTMAINWIN_H

class QSpinBox; 		// cookieBoxes
class QTableItem;		// localAcctItems
class QToolButton;		// addButton
class QListViewItem;
class QSplitter;		// topSplitter

#include <qdict.h>		// allGroups, allServices
#include <qptrdict.h>		// items dicts
#include <qstringlist.h>	// modes

class EbQtService;
class EbQtLocalAccount;
class EbQtContact;
class EbQtGroup;
class EbQtSocket;

class EbQtConv;
class EbQtAdd;
class EbQtAwayDlg;
class EbQtPrefPage;
class EbQtBuddyView;
class EbQtBuddyViewItem;

#include "ebqt.h"
#include "ebqtmainwinui.h"	// parent class from Designer
#include "ebqtcommand.h"
#include "ebqtaccount.h"
#ifdef Q_WS_X11
#include "ebqttrayicon.h"
#endif

/**
  * EbQtMainWin is the main window (the buddy list) of EbQt.
  * It also seemed as good a place as any to put the incoming event processing
  * (other dialogs and stuff are "owned" by this window)
  *
  * @author Chris Boyle
  */
class EbQtMainWin : public EbQtMainWinUI
{
	Q_OBJECT

public:
	EbQtMainWin(QWidget * parent = 0, const char * name = 0);
	~EbQtMainWin();

public slots:
	/** try to load a local cookie */
	bool loadCookie() { return loadCookie(FALSE); }  // moc can't do defaults
	bool loadCookie(bool quietly);
	/** open the server preferences dialog */
	void tryShowPrefs();
	/** shows the aboutQt box */
	void aboutQt();
	/** shows an about dialog */
	void showAboutBox();

signals:
	void buddyListChanged();

protected:
	void closeEvent(QCloseEvent * ce);
	void moveEvent(QMoveEvent * e);
	void resizeEvent(QResizeEvent * e);

private slots:
	/** toggle the toolbar*/
	void toggleToolBar(bool toggle, bool sendToServer);
	// slot system won't work with default param values
	void toggleToolBar(bool toggle) { toggleToolBar(toggle, TRUE); }
	/** toggle the statusbar*/
	void toggleStatusBar(bool toggle, bool sendToServer);
	// slot system won't work with default param values
	void toggleStatusBar(bool toggle) { toggleStatusBar(toggle, TRUE); }

	/** process the one given command */
	void processCommand(const EbQtCommand & command);
	/** process all outstanding commands */
	void processCommands();

	/** handle buddy list creation commands */
	void createBuddyList(
		const QString &mkGroup   = QString::null,
		const QString &mkContact = QString::null,
		const QString &mkLocal   = QString::null,
		const QString &mkService = QString::null,
		const QString &mkAccount = QString::null);

	/** try and connect with the given address
	  * (or run an error dialog if that doesn't make sense) */
	void tryConnect();
	void disconnectCore() { connectionClosed(FALSE); }

	/** try to launch a core and connect to it using a socketpair() */
	void launchAndConnect();
	void resetLaunchCmd();
	void killLaunchedCore();
	
	/** change status message */
	void hostLookup();
	/** change status message */
	void hostFound();
	/** report successful connection and carry on */
	void hostConnected();
	/** deal with the other side closing the connection */
	void connectionClosed(bool showMsg = TRUE);

	/** handle socket errors */
	void processSockError(int error);

	/** enable/disable most of the window based on the socket's state */
	void setConnected();
	bool isConnected() const { return connected; }

	/** change what's visible in the buddy list (combo box in top left) */
	void changeWho(int who);
	void changeWhoQuietly(int who);
	void changeWho();
	/** change how the buddy list appears (combo box in top right) */
	void changeHow(int how);
	void changeHow();
	/** called when the user messes with tree expansion manually */
	void customTreeExpansion();

	void updateLocalAcctItem(EbQtLocalAccount * l);
	void   updateAccountItem(EbQtAccount      * a);
	void   updateContactItem(EbQtContact      * c);
	void     updateGroupItem(EbQtGroup        * g);
	void updateAll();

	void renameContact(const QString & newName, EbQtContact * contact);

	// these are for connecting to the destroyed(QObject *) signal to kill items
	void removeLocalAcctItem(QObject * o);
	void   removeAccountItem(QObject * a) {   accountItems.remove(a); }
	void   removeContactItem(QObject * c) {   contactItems.remove(c); }
	void     removeGroupItem(QObject * g) {     groupItems.remove(g); }

	void removeConversation(EbQtConv * conv);
	void removeGroupConv(EbQtConv * conv);

	void tryBuddyAction(const QString & action, EbQtAccount * a);

	void tabChanged(QWidget * tab);
	void setSelectionActions();
	void buddyRMB(QListViewItem * i, const QPoint & pos);
	void localAcctRMB(int row, int col, const QPoint & pos);

	// these use QObject::sender() to get the button
	// then they look at the name of the parent for the tag:
	// slightly ugly, I know
	void tryResolveErrorDlg();
	void tryResolveYesNoDlg();
	void tryResolveListDlg();
	void tryResolveTextDlg();

	void trySignOn(bool on);
	void trySignOff(bool off);
	void updateSignedOnOff();

	void tryAdd();
	void tryAdd(const QString & a, EbQtLocalAccount * l, EbQtConv * gc);
	void tryAdd(const QString & g, const QString & c,
		const QString & l, const QString & s, const QString & a);
	void tryRemove();
	void tryRemove(EbQtAccount * a);
	void tryRemove(EbQtContact * c);
	void tryRemove(EbQtGroup * g);
	void tryRemove(EbQtLocalAccount * l);
	
	void tryRename(QListViewItem * item, int col, const QString & newName);
	void tryCreateBuddyList(
		const QString & mkGroup   = QString::null,
		const QString & mkContact = QString::null,
		const QString & mkLocal   = QString::null,
		const QString & mkService = QString::null,
		const QString & mkAccount = QString::null);
	void tryChangeLocalStatus(int row, int col = 0);
	void tryChangeLocalStatus(const QString & status, EbQtLocalAccount * l);
	
	void selectLocalAcct(int row, int col);
	void selectLocalAcct(EbQtPrefPage * page);
	
	void trySend(EbQtLocalAccount * l, EbQtAccount * a,
		const QString & msg);
	void tryGroupSend(const QString & msg, const QString & id);
	void tryGroupInvite(const QString & handle, const QString & id);
	void tryGroupLeave(const QString & id);
	void tryOpenConv();
	void tryOpenConv(QListViewItem * i);
	void tryOpenConv(EbQtContact * c);
	void tryOpenConv(EbQtAccount * a);
	void tryOpenConv(const QString & u, EbQtConv * conv);
	
	/** asks the server to save all options */
	void trySaveConfig();
	
	void updateAway();
	void tryAway(bool away = FALSE);
	
	/** builds and displays the join group chat dialog */
	void tryJoinGroup();
	
	/** refreshes the preferences on the accounts tab (the account editor) */
	void refreshAcctPrefs();
	
	void removePrefPage(QObject * p) { prefPages.remove(p->name()); }
	void refreshPrefPage(EbQtPrefPage * page);
	void refreshPrefPage(const QString & page);
	void trySetPref(const QString & name, const QString & value, EbQtPrefPage * page);
	
	/** operates on selected item */
	void startRename();
	void startRename(EbQtContact * c);
	void startRename(EbQtGroup * g);
	/** operates on selected item */
	void makeAcctPreferred();
	void makeAcctPreferred(EbQtAccount * a);
	
	void tryMoveContact(const QString & group, EbQtContact * contact);
	void tryMoveAccount(EbQtContact * contact, EbQtAccount * account);
	
	void tryIgnore(bool ignored) { tryIgnore(ignored, NULL); }
	void tryIgnore(bool ignored, EbQtContact * c);
	void tryIgnore(EbQtContact * c);
	
	void tryChatAction(const QString & action, const QString & chat,
		EbQtLocalAccount * local);
	void tryChatUserAction(const QString & user, const QString & action,
		const QString & chat);
	void doChatUserMenu(const QString & user, int userId,
		const QPoint & pos, EbQtConv * conv);
	
	/** toggle temporarily hiding the entire app (status icon click) */
	void setInvisibility(bool on);
	/** updates anywhere that needs a summary of currently online
	  * contacts/accounts (only the systray at the moment) */
	void updateSummary();
	/** slot to launch the tray menu at a point */
	void doTrayMenu(const QPoint & where);
	
	void toggleConvsInTabs(bool on, bool sendToServer);
	// slot system won't work with default param values
	void toggleConvsInTabs(bool on) { toggleConvsInTabs(on, TRUE); }
	
	void toggleGroupConvsInTabs(bool on, bool sendToServer);
	// slot system won't work with default param values
	void toggleGroupConvsInTabs(bool on) { toggleGroupConvsInTabs(on, TRUE); }
	
	void addConvTab(EbQtConv * conv);
	void removeConvTab(EbQtConv * conv);
	void setConvsTabCaption(const QPixmap & pix, const QString & caption,
		QWidget * conv);
	void raiseAndActivate(QWidget * w);
	
	void tryGeneralAction(int which);
	void tryGroupAction(int which, EbQtGroup * g);
	void tryContactAction(int which, EbQtContact * c);
	void tryAcctServiceAction(int which, EbQtAccount * a);
	void tryAcctGenericAction(int which, EbQtAccount * a);
	
	void getInitialPrefs();
	void gotGeneralPref(const QString & key, const QString & value);
	void tryGetGeneralPref(const QString & key);
	void putGeneralPref(const QString & key, const QString & value);
	void gotContactPref(const QString & key, const QString & value,
		EbQtContact * c);
	void tryGetContactPref(const QString & key, EbQtContact * c);
	void putContactPref(const QString & key, const QString & value,
		EbQtContact * c);
	void putGeometries();
	void putConvGeometry(EbQtConv * conv);
	
	void doCascadeConvs();
	void doCascadeGroupConvs();
	// moc doesn't really understand default arguments, and some of these
	// need to be separate slots too
	void setConvsUndocked(bool on) { setConvsUndocked(on, TRUE); }
	void setConvsUndocked(bool on, bool sendToServer);
	void setConvsDocked(bool right, bool on, bool sendToServer);
	void setConvsDockLeft(bool on) { setConvsDockLeft(on, TRUE); }
	void setConvsDockLeft(bool on, bool sendToServer)
	{ setConvsDocked(FALSE, on, sendToServer); }
	void setConvsDockRight(bool on) { setConvsDockRight(on, TRUE); }
	void setConvsDockRight(bool on, bool sendToServer)
	{ setConvsDocked(TRUE, on, sendToServer); }
	
	void notifyContactStatus(EbQtAccount::AccountStatus old, EbQtContact * c);
	
	void restoreRHSpos();
	void restoreSplitterSizes();

private:
	int prevRHSpos;
	QValueList<int> prevSplitterSizes;

	/** builds the tray menu, caller must delete either directly or by
	  * deleting parent (submenus will be deleted automatically) */
	QPopupMenu * trayMenu(QWidget * parent);
	/** builds a group menu, caller must delete either directly or by
	  * deleting parent (submenus will be deleted automatically) */
	QPopupMenu * groupMenu(QWidget * parent, EbQtGroup * g);
	/** builds a contact menu, with account submenus (except for hideAcct
	  * if given), caller must delete either directly or by deleting
	  * parent (submenus will be deleted automatically) */
	QPopupMenu * contactMenu(QWidget * parent, EbQtContact * c,
		bool showAccts);
	/** builds an account menu, caller must delete either directly or by
	  * deleting parent (submenus will then be deleted automatically) */
	QPopupMenu * accountMenu(QWidget * parent, EbQtAccount * a,
		bool showContact, bool showLocal);
	/** builds a local acct menu, with account submenus (except for
	  * hideAcct if given), caller must delete either directly or by
	  * deleting parent (submenus will be deleted automatically) */
	QPopupMenu * localAccountMenu(QWidget * parent,
		EbQtLocalAccount * l, bool showAccts);
	
	/** a custom socket (works with EbQtCommands rather than bytes) */
	EbQtSocket *sock;
	/** whether we've _finished_ connecting (got contact list) */
	bool connected;
	
	QVBoxLayout * listLayout;
	EbQtBuddyView * buddyView;
	
#ifdef Q_WS_X11
	EbQtTrayIcon * trayIcon;
#endif
	QAction * toggleInvisibility;
	
	/** all services: we deal with name uniqueness here */
	QDict<EbQtService> allServices;
	/** all groups:   we deal with name uniqueness here */
	QDict<EbQtGroup> allGroups;
	// NB, contacts: name uniqueness is handled by the group
	// (i.e. family/eleanor and leverkusen/eleanor can exist simultaneously)
	// NB, accounts: name uniqueness is handled by the service
	// (NOT the contact, who may have e.g. yahoo/kerneloops and aim/kerneloops)
	
	/** find the tableitem    for a  local account */
	QPtrDict<QTableItem>    localAcctItems;
	/** find the viewitem for an account       */
	QPtrDict<EbQtBuddyViewItem> accountItems;
	/** find the viewitem for a  contact       */
	QPtrDict<EbQtBuddyViewItem> contactItems;
	/** find the viewitem for a  group         */
	QPtrDict<EbQtBuddyViewItem> groupItems;
	
	/** contact conversations */
	QPtrDict<EbQtConv> singleConvs;
	/** conversations by group chat id */
	QDict<EbQtConv> groupConvs;
	
	/** dialogs that exist right now, by "tag code" */
	QDict<QDialog> dialogs;

	/** actions not applied to any particular buddy-list object */
	QStringList generalActions;

	/** the authcookie */
	QPtrList<QSpinBox> cookieBoxes;
	
	EbQtAdd * addDlg;
	
	bool lastAway;
	QString lastAwayTitle;
	QString lastAwayBody;
	
	bool eventFilter(QObject * o, QEvent * e);
	
	QDict<EbQtPrefPage> prefPages;
	EbQtPrefPage * newPrefPageInDialog(const QString & name);
	
	EbQtConv * getConv(EbQtContact * c);
	EbQtConv * getGroupConv(EbQtLocalAccount * l, const QString & id);
	
	bool showOfflineContacts;
	bool showContactsExpanded;
	void updateShowContactsExpanded();
	
	QTabWidget * convsTabWidget;
	QWidget * newConvsTLW();
	QTabWidget * getConvsTabWidget();
	void updateConvsTabWidget();
	EbQtConv * newConv(bool useTabs, const QString & name,
		EbQtContact * c = NULL);
	void closedConv(EbQtConv * conv);
	
	QRect stringToRect(const QString & whxy);
	QString rectToString(const QRect & r);
	QRect mainGeometry, tabsGeometry;
	QTimer * geoChangeTimer;
	/** cascade calculations: given \a count of windows which will be
	  * cascaded, and \a centerRect, the desired geometry of the center
	  * window, you get a thoroughly range-checked (closest possible)
	  * geometry (frame included) of the top-left window in the cascade
	  * (which you can then QRect::moveBy() the increment */
	static QRect cascadeRect(unsigned int count, const QRect & centerRect);
	
	QSplitter * topSplitter;
};

#endif

