/***************************************************************************
                          ebqtlocalaccount.h  -  description
                             -------------------
    begin                : Thu Dec 19 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTLOCALACCOUNT_H
#define EBQTLOCALACCOUNT_H

#include <qobject.h>
#include <qdict.h>
#include <qptrdict.h>

class EbQtService;
class EbQtAccount;

#include "ebqt.h"
#include "ebqtaccount.h"

/**
  * EbQtLocalAccount is a local account, i.e. one that you sign in with.
  * The handle is QObject::name();
  *
  * @author Chris Boyle
  */

class EbQtLocalAccount : public QObject {
	Q_OBJECT

public: 
	EbQtLocalAccount(EbQtService * parent, const QString & name);
	~EbQtLocalAccount();
	QString name() const { return handle; }
	EbQtService * service() const { return (EbQtService *)parent(); }
	QDictIterator<EbQtAccount> accounts() {
		return QDictIterator<EbQtAccount>(acctDict); }
	EbQtAccount * account(const QString & name) { return acctDict[name]; }
	
	QString	statusMsg() const { return lastStatusMsg; }
	bool	connected() const { return  wasConnected; }
	bool	    ready() const { return      wasReady; }
	
	void addAccount(EbQtAccount * account);
	void takeAccount(EbQtAccount * account);
	void removeAccount(const QString & name);

public slots:
	void setName(const QString & name) { handle = name;
		QObject::setName(QString("local account %1").arg(name)); }
	void setStatusMsg(const QString &msg);
	void setConnected(bool c);
	void setReady(bool r);
	void remove() { emit(wantsRemove(this)); }
	void changeStatus(int which);

signals:
	void statusMsgChanged();
	void becameConnected();
	void becameDisconnected();
	void becameReady();
	void becameNotReady();
	void itemNeedsUpdate(EbQtLocalAccount * l);
	void wantsRemove(EbQtLocalAccount * l);
	void wantsStatusChange(const QString & status, EbQtLocalAccount * l);
	void accountAdded(EbQtAccount * a, EbQtLocalAccount * l);
	void accountRemoving(EbQtAccount * a, EbQtLocalAccount * l);

private:
	QString handle;
	QDict<EbQtAccount> acctDict;
	QString lastStatusMsg;
	bool wasConnected;
	bool wasReady;
};

#endif
