/***************************************************************************
                          ebqtlocalaccount.cpp  -  description
                             -------------------
    begin                : Thu Dec 19 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include "ebqtlocalaccount.h"
#include "ebqtservice.h"

EbQtLocalAccount::EbQtLocalAccount(EbQtService * parent, const QString & name) :
	QObject(parent),
	lastStatusMsg(""),
	wasConnected(FALSE),
	wasReady(FALSE)
{
	setName(name);
	acctDict.setAutoDelete(TRUE);
}

EbQtLocalAccount::~EbQtLocalAccount()
{
	acctDict.clear();  // ensure deletion
}

void EbQtLocalAccount::addAccount(EbQtAccount * account)
{
	acctDict.insert(account->name(), account);
	emit(accountAdded(account, this));
}

void EbQtLocalAccount::takeAccount(EbQtAccount * account)
{
	emit(accountRemoving(account, this));
	acctDict.take(account->name());
}

void EbQtLocalAccount::removeAccount(const QString & name)
{
	EbQtAccount * a = acctDict[name];
	if (! a) return;
	emit(accountRemoving(a, this));
	acctDict.remove(name);
}

void EbQtLocalAccount::setStatusMsg(const QString &msg)
{
	if (lastStatusMsg == msg) return;
	lastStatusMsg = msg;
	emit(statusMsgChanged());
	emit(itemNeedsUpdate(this));
}

void EbQtLocalAccount::setConnected(bool c)
{
	if (wasConnected == c) return;
	if (wasConnected)
		emit(becameDisconnected());
	else
		emit(becameConnected());
	wasConnected = c;
	emit(itemNeedsUpdate(this));
}

void EbQtLocalAccount::setReady(bool r)
{
	if (wasReady == r) return;
	if (wasReady)
		emit(becameNotReady());
	else
		emit(becameReady());
	wasReady = r;
	emit(itemNeedsUpdate(this));
}

void EbQtLocalAccount::changeStatus(int which)
{
	emit(wantsStatusChange(service()->states[which], this));
}

