/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void EbQtJoinDlg::changeService()
{
	QString text = serviceCB->currentText();
	bool e = text.isEmpty();
	bool setL = FALSE;
	
	localCB->setEnabled(! e);
	lclLabel->setEnabled(! e);
	svc = e ? NULL : (*allServices)[text];
	localCB->blockSignals(TRUE);
	localCB->clear();
	if (svc) {
		int firstReady = -1;
		QDictIterator<EbQtLocalAccount> li = svc->localAccounts();
		for (; li.current(); ++li) {
			bool r = (*li)->ready();
			localCB->insertItem(svc->pixmap(16,16, ! r), li.currentKey());
			if (r && firstReady < 0)
				firstReady = localCB->count() - 1;
		}
		if (firstReady >= 0) {
			localCB->setCurrentItem(firstReady);
			setL = TRUE;
		}
	}
	localCB->blockSignals(FALSE);
	if (setL)
		localCB->setFocus();
	changeLocal();
}

void EbQtJoinDlg::changeLocal()
{
	QString text = localCB->currentText();
	bool e = text.isEmpty();
	
	lcl = (! e && svc) ? svc->localAccount(text) : NULL;
	bool r = lcl && lcl->ready();
	bool needChan = r && svc->hasNamedChats();
	channelEdit->setEnabled(needChan);
	channelLabel->setEnabled(needChan);
	if (needChan)
		channelEdit->setFocus();
	else
		channelEdit->clear();
	joinButton->setEnabled(r);  // null channel is allowed
	changeChannel();
}

void EbQtJoinDlg::changeChannel()
{
	// null channel is allowed
	//joinButton->setEnabled(! channelEdit->text().isEmpty());
	// TODO: maybe require a name if svc->hasNamedChats()?
}

void EbQtJoinDlg::refreshServices(QDict<EbQtService> * svcList)
{
	allServices = svcList;
	serviceCB->blockSignals(TRUE);
	serviceCB->clear();
	if (allServices) {
		QDictIterator<EbQtService> si(*allServices);
		for(; si.current(); ++si) {
			if ((*si)->canGroupChat()) {
				serviceCB->insertItem((*si)->pixmap(16,16),
					si.currentKey());
			}
		}
	}
	serviceCB->blockSignals(FALSE);
	changeService();
}


void EbQtJoinDlg::showEvent(QShowEvent *)
{
	if (svc)
		if (lcl && lcl->ready())
			channelEdit->setFocus();
		else
			localCB->setFocus();
	else
		serviceCB->setFocus();
}
