/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void EbQtIgnoreDlg::showEvent(QShowEvent *)
{
	responseEdit->moveCursor(QTextEdit::MoveEnd, FALSE);
	responseEdit->selectAll();
}

QString EbQtIgnoreDlg::response()
{
	return responseEdit->text();
}

void EbQtIgnoreDlg::setResponse( const QString & text )
{
	responseEdit->setText(text);
}

void EbQtIgnoreDlg::init()
{
#if (QT_VERSION >= 0x030100)
	responseEdit->setTabChangesFocus(TRUE);
#endif
	responseEdit->installEventFilter(this);
}

bool EbQtIgnoreDlg::eventFilter( QObject * o, QEvent * e )
{
	if (o == responseEdit && e->type() == QEvent::KeyPress) {
		QKeyEvent * k = (QKeyEvent *) e;
		// Return, not Shift+Return or anything else + Return
		if (k->key() == Qt::Key_Return && k->state() == Qt::NoButton) {
			k->accept();
			accept();
			return TRUE;  // hide this from sendEdit
		}
	}
	return QDialog::eventFilter(o, e);
}
