/***************************************************************************
                          ebqtgroup.h  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTGROUP_H
#define EBQTGROUP_H

#include <qobject.h>
#include <qdict.h>  // contacts

#include "ebqt.h"
#include "ebqtcontact.h"

/**
  * EbQtGroup is an Everybuddy group, holding a list of contacts
  * The group name is QObject::name()
  *
  * @author Chris Boyle
  */

class EbQtGroup : public QObject
{
	Q_OBJECT

public: 
	EbQtGroup(QObject * parent, const QString & name);
	~EbQtGroup();
	QString name() const { return groupName; }
	QDictIterator<EbQtContact> contacts() {
		return QDictIterator<EbQtContact>(contactDict); }
	EbQtContact * contact(const QString & name) { return contactDict[name]; }
	EbQtAccount::AccountStatus status() const { return lastStatus; }
	bool isOnline() const { return lastStatus > EbQtAccount::Offline; }
	static QStringList actions;

public slots:
	void setName(const QString & name) { groupName = name;
		QObject::setName(QString("group %1").arg(name)); }
	void addContact(EbQtContact * contact);
	void takeContact(EbQtContact * contact);
	void updateContactsOnline();
	void renameContact(const QString & newName, EbQtContact * contact);
	void removeContact(const QString & name) { contactDict.remove(name); }
	void remove() { emit(wantsRemove(this)); }
	void startRename() { emit(wantsRenameStart(this)); }
	void tryAction(int which) { emit(wantsAction(which, this)); }

signals:
	void itemNeedsUpdate(EbQtGroup * g);
	void wantsRemove(EbQtGroup * g);
	void wantsRenameStart(EbQtGroup * g);
	void wantsAction(int which, EbQtGroup * g);

private:
	QString groupName;
	QDict<EbQtContact> contactDict;
	EbQtAccount::AccountStatus lastStatus;
};

#endif
