/***************************************************************************
                          ebqtgroup.cpp  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include "ebqtgroup.h"

QStringList EbQtGroup::actions;

EbQtGroup::EbQtGroup(QObject * parent, const QString & name) :
	QObject(parent),
	lastStatus(EbQtAccount::Offline)
{
	setName(name);
	contactDict.setAutoDelete(TRUE);
}

EbQtGroup::~EbQtGroup()
{
}

void EbQtGroup::addContact(EbQtContact * contact)
{
	connect(contact, SIGNAL(nameChanged(const QString &, EbQtContact *)),
		SLOT(renameContact(const QString &, EbQtContact *)));
	connect(contact, SIGNAL(statusChanged(EbQtContact *)), SLOT(updateContactsOnline()));
	contactDict.insert(contact->name(), contact);
	updateContactsOnline();
}

void EbQtGroup::takeContact(EbQtContact * contact)
{
	disconnect(contact, 0, this, 0);
	contactDict.take(contact->name());
	updateContactsOnline();
}

void EbQtGroup::updateContactsOnline()
{
	EbQtAccount::AccountStatus maxStatus = EbQtAccount::Offline;
	for (QDictIterator<EbQtContact> ci(contactDict); ci.current(); ++ci)
		if ((*ci)->status() > maxStatus)
			maxStatus = (*ci)->status();
	if (maxStatus == lastStatus)
		return;
	lastStatus = maxStatus;
	emit(itemNeedsUpdate(this));
}

void EbQtGroup::renameContact(const QString & newName, EbQtContact * contact)
{
	contactDict.take(contact->name());  // old name
	contactDict.insert(newName, contact);
}

