/***************************************************************************
                          ebqtconv.h  -  description
                             -------------------
    begin                : Wed Dec 25 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTCONV_H
#define EBQTCONV_H

class QListBoxPixmap;
class QStyleSheetItem;
class QPopupMenu;

#include <qwidget.h>
#include <qptrlist.h>
#include <qdict.h>
#include <qpixmap.h>

class EbQtContact;
class EbQtService;
class EbQtLocalAccount;
class EbQtAccount;

#include "ebqt.h"
#include "ebqtconvui.h"
#include "ebqttextedit.h"

/**
  * conversation widgets for EbQt
  *
  * @author Chris Boyle
  */

class EbQtConv : public EbQtConvUI  {
	Q_OBJECT

public:
	EbQtConv(QWidget * parent, const char * name = 0, EbQtContact * c = 0,
		WFlags f = 0);
	~EbQtConv();
	
	EbQtContact * contact() const { return groupMode ? NULL        : singleContact; }
	const QString & id()    const { return groupMode ? groupChatID : QString::null; }
	EbQtLocalAccount * localAcct() const { return localAccount; }  // may be null
	QPixmap normalIcon() const { return cleanIcon; }

public slots:
	void setSingleContact(EbQtContact * contact);
	void setGroupChat(const QString & id, EbQtLocalAccount * localAccount);
	
	void sentMsg(EbQtLocalAccount * l, EbQtAccount * a,
		const QString & msg,    int secsAgo = 0);
	void sent3rd(EbQtLocalAccount * l, EbQtAccount * a,
		const QString & action, int secsAgo = 0);
	void recvMsg(EbQtLocalAccount * l, EbQtAccount * a,
		const QString & msg,    int secsAgo = 0);
	void recv3rd(EbQtLocalAccount * l, EbQtAccount * a,
		const QString & action, int secsAgo = 0);
	void sentGroupMsg(const QString & msg);
	void recvGroupMsg(const QString & from, const QString & msg);
	void recvGroup3rd(const QString & msg);
	/** refresh the list of available accounts (local and remote) for this contact */
	void refreshAccounts();
	/** set the combos (0 -> whatever the ptrlists have as current) */
	bool setCurrents(EbQtLocalAccount * l = 0, EbQtAccount * a = 0);
	void addGroupUser(const QString & handle, bool quiet = FALSE);
	void removeGroupUser(const QString & handle, bool quiet = FALSE);
	void tryClose();
	void tryChatUserAction(int userAndAction);
	void tryAddFromGroup(int user);
	void setCaption(const QString & c) { QWidget::setCaption(c);
		emit(captionChanged(*(icon()), caption(), this)); }
	void setIcon(const QPixmap & pix) { cleanIcon = pix; setTempIcon(pix); }
	void focusSendEdit();
	void flash(unsigned int times = 0);

signals:
	void wantsToSend(EbQtLocalAccount * l, EbQtAccount * a, const QString & msg);
	void wantsGroupSend(const QString & msg, const QString & id);
	void wantsIgnore(EbQtContact * contact);
	void wantsGroupInvite(const QString & handle, const QString & id);
	void wantsGroupLeave(const QString & id);
	void convClosing(EbQtConv * conv);
	void wantsChatAction(const QString & action, const QString & id,
		EbQtLocalAccount * local);
	void wantsChatUserAction(const QString & user, const QString & action,
		const QString & id);
	void wantsChatUserMenu(const QString & user, int userId, const QPoint & pos,
		EbQtConv * conv);
	void wantsOpenConv(const QString & user, EbQtConv * conv);
	void wantsAdd(const QString & a, EbQtLocalAccount * l, EbQtConv * conv);
	void captionChanged(const QPixmap & pix, const QString & caption,
		QWidget * conv);
	void wantsGeometrySave(EbQtConv * conv);

protected:
	void keyPressEvent(QKeyEvent * k);
	void moveEvent(QMoveEvent * e);
	void resizeEvent(QResizeEvent * e);
	void closeEvent(QCloseEvent * ce);
	void setTempIcon(const QPixmap & pix) { QWidget::setIcon(pix);
		emit(captionChanged(*(icon()), caption(), this)); }
	void focusInEvent(QFocusEvent * e);
	void enterEvent(QEvent * e);

private:
	bool eventFilter(QObject * o, QEvent * e);
	
	/** applied to _any_ message text received from the server
	  * (no-op these days) */
	static QString cook(QString text);
	/** applied (before cook) to what the server says we sent */
	static QString cookSent(QString text);
	/** applied before we send a message
	  * (must be able to consider e.g. default font size) */
	QString cookSend(QString text);
	
	bool recvEditNearBottom();
	
	void maybeFlash();
	
	bool groupMode;  // false -> single contact
	QString groupChatID;
	
	EbQtContact			* singleContact;
	QPtrList<EbQtLocalAccount>	  localAccounts;
	EbQtLocalAccount		* localAccount;
	QPtrList<EbQtAccount>		  accounts;
	EbQtAccount			* account;
	
	EbQtTextEdit * sendEdit;
	QDict<QListBoxPixmap> groupItems;
	bool canClose;
	QStyleSheetItem * timeStamps;
	QPixmap cleanIcon;
	QTimer * geoChangeTimer;
	QTimer * flashTimer;

	QPopupMenu * inviteMenu;
	QPopupMenu * actionsMenu;

private slots:
	void addMessage(const QString & from, const QString & rawText, int secsAgo,
		const QColor & colour, const QColor & tsColour,
		bool thirdPerson = FALSE);
	void addLine(const QString & line);
	
	void fromChanged(int from);
	void toChanged(int to);
	/** account selections have changed, respond */
	void updateAccounts();
	void updateLocalAcct(EbQtLocalAccount * l);
	void updateLocalAcctItem(EbQtLocalAccount * l);
	void removeLocalAccount(EbQtLocalAccount * l);
	void updateAccount(EbQtAccount * a);
	void updateAccountItem(EbQtAccount * a);
	void removeAccount(EbQtAccount * a);
	
	void trySend();
	void tryInviteOther();
	
	void recvEditToBottom();
	
	/** set whether the contact is ignored */
	void setIgnore(bool ignored);
	void ignoredSet(bool ignored);
	
	void showTimeStamps(bool on);
	void showCombos(bool on);
	void updateUsers();
	void tryChatAction(int i);
	/** QToolButton doesn't make openPopup a slot
	  * (maybe because it waits for selection?) */
	void popupInvite();
	void popupActions();
	
	void usersRMB(QListBoxItem * i, const QPoint & pos);
	void usersDblClick(QListBoxItem * i);
	void updateGroupUserItem(const QString & handle, bool removing = FALSE);
	void setLocalAcct(EbQtLocalAccount * l);
	void addedAccount(EbQtAccount * a);
	void removingAccount(EbQtAccount * a);
	
	void putGeometry() { emit(wantsGeometrySave(this)); }
};

#endif

