/***************************************************************************
                          ebqtconv.cpp  -  description
                             -------------------
    begin                : Wed Dec 25 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qregexp.h>
#include <qdict.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qdatetime.h>
#include <qtoolbutton.h>
#include <qapplication.h>	// allowing recvEdit to sync
#include <qlineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistbox.h>		// group users view
#include <qinputdialog.h>	// invite user
#include <qlcdnumber.h>		// users count
#include <qstylesheet.h>	// timestamp hiding
#include <qpopupmenu.h>		// various
#include <qbitmap.h>		// masking for group users view
#include <qwmatrix.h>		// rotation
#include <qtimer.h>

#include "ebqtconv.h"
#include "ebqtservice.h"
#include "ebqtlocalaccount.h"
#include "ebqtaccount.h"
#include "ebqtcontact.h"
#include "ebqtgroup.h"
#undef EBQT_CONV_USE_TABLE

EbQtConv::EbQtConv(QWidget * parent, const char * name, EbQtContact * c, WFlags f) :
	EbQtConvUI(parent, name, f),
	groupMode(FALSE),
	singleContact(NULL),
	localAccount(NULL),
	account(NULL),
	sendEdit(new EbQtTextEdit(sendEditFrame, "sendEdit")),
	canClose(TRUE),
	geoChangeTimer(new QTimer(this, "geoChangeTimer")),
	flashTimer(new QTimer(this)),
	inviteMenu(NULL),
	actionsMenu(NULL)
{
	recvEdit->setStyleSheet(new QStyleSheet(recvEdit));  // has to be per-conv
	timeStamps = new QStyleSheetItem(recvEdit->styleSheet(), "ts");
	QStyleSheetItem * p = recvEdit->styleSheet()->item("p");
	p->setMargin(QStyleSheetItem::MarginAll,	  0);
//	p->setMargin(QStyleSheetItem::MarginTop,	  0);
//	p->setMargin(QStyleSheetItem::MarginBottom,	  0);
//	p->setMargin(QStyleSheetItem::MarginRight,	  0);
//	p->setMargin(QStyleSheetItem::MarginLeft,	 20);
//	p->setMargin(QStyleSheetItem::MarginFirstLine,	-20);  // FIXME
#if (QT_VERSION >= 0x030100)
	// AtWordOrDocumentBoundary is new in Qt 3.1
	recvEdit->setWrapPolicy(QTextEdit::Anywhere);
	
	QVBoxLayout * sendLayout = new QVBoxLayout(sendEditFrame, 0, 0);
	sendLayout->addWidget(sendEdit);
	sendLayout->activate();
#endif
	sendEdit->textEdit->setStyleSheet(recvEdit->styleSheet());
	
	// swallow return presses to trySend()
	// this way we can select just events with no modifiers, so shift+ret
	// works to get a newline; also we don't get an extra \n on the text
	sendEdit->textEdit->installEventFilter(this);
	typingHint->setEnabled(FALSE);  // not implemented
	setSingleContact(c);
	connect(geoChangeTimer, SIGNAL(timeout()), SLOT(putGeometry()));
	connect(flashTimer, SIGNAL(timeout()), SLOT(flash()));
	
	// danger, fragile code ahead. you'll know this is broken if focus
	// starts making a point of *not* being in sendEdit...
	// (this can't be done in designer since it doesn't know about
	// sendEdit which, to be convenient, must be first)
	setTabOrder(sendEdit->textEdit, toCB);
	setTabOrder(toCB, fromCB);
	setTabOrder(fromCB, usersBox);
	setTabOrder(usersBox, recvEdit);
	// (add anything else here)
	// ...then back to sendEdit->textEdit, but *DON'T* say so
	// (or else recvEdit will be first, which is bad)
	focusSendEdit();  // make very sure
}

EbQtConv::~EbQtConv()
{
}

void EbQtConv::setSingleContact(EbQtContact * contact)
{
	if (singleContact) {
		disconnect(singleContact, 0, this, 0);
	}
	if (actionsMenu) delete actionsMenu;
	if (contact->actions.count() > 0) {
		sglAction->setEnabled(TRUE);
		actionsMenu = new QPopupMenu(this, "chatActionMenu");
		for (unsigned int i=0; i < contact->actions.count(); i++) {
			actionsMenu->setItemParameter(actionsMenu->insertItem(
				contact->actions[i], contact,
				SLOT(tryAction(int))), i);
		}
	} else {
		sglAction->setEnabled(FALSE);
		actionsMenu = NULL;
	}
	singleContact = contact;
	if (contact) {
		groupMode = FALSE;
		canClose = TRUE;
		groupUsersFrame->hide();
		showSingleAccts->show();
		sglAction->show();
		showCombos(showSingleAccts->isOn());
		
		connect(contact, SIGNAL(destroyed(QObject *)),
			SLOT(deleteLater()));
		connect(contact, SIGNAL(lostAccount(EbQtAccount *)),
			SLOT(removeAccount(EbQtAccount *)));
		connect(contact, SIGNAL(nameChanged(const QString &, EbQtContact *)),
			SLOT(setCaption(const QString &)));
		connect(contact, SIGNAL(ignoredChanged(bool)),
			SLOT(ignoredSet(bool)));
		setCaption(contact->name());
	} else {
		groupUsersFrame->hide();
		showSingleAccts->hide();
		sglAction->hide();
		showCombos(FALSE);
		setCaption(tr("Conversation"));
	}
	refreshAccounts();
	updateGeometry();
}

void EbQtConv::setGroupChat(const QString & id, EbQtLocalAccount * localAccount)
{
	setSingleContact(NULL);
	groupMode = TRUE;
	canClose = FALSE;
	groupChatID = id;
	setLocalAcct(localAccount);
	usersBox->clear();
	groupUsersFrame->show();
	showSingleAccts->hide();
	sglAction->hide();
	ignoreButton->hide();
	showCombos(FALSE);
	
	if (inviteMenu) delete inviteMenu;
	inviteMenu = new QPopupMenu(this, "inviteMenu");
	
	if (actionsMenu) delete actionsMenu;
	QStringList actions = localAccount->service()->groupChatActions;
	chatAction->setEnabled(actions.count() > 0);
	if (actions.count() > 0) {
		actionsMenu = new QPopupMenu(this, "chatActionMenu");
		// yeah, I know there's an iterator, but I want the position
		for (unsigned int i=0; i < actions.count(); i++) {
			actionsMenu->setItemParameter(
				actionsMenu->insertItem(actions[i],
					this, SLOT(tryChatAction(int))), i);
		}
	} else
		actionsMenu = NULL;
	updateGeometry();
}

void EbQtConv::refreshAccounts()
{
	EbQtLocalAccount * prevLocal = localAccount;
	EbQtAccount * prevAccount = account;
	
	QPtrListIterator<EbQtLocalAccount> li(localAccounts);
	for(; li.current(); ++li) {
		disconnect(*li, 0, this, 0);
	}
	localAccounts.clear();
	
	accounts.clear();
	fromCB->blockSignals(TRUE);
	toCB->blockSignals(TRUE);
	fromCB->clear();
	toCB->clear();
	if (singleContact) {
		QPtrListIterator<EbQtAccount> ai = singleContact->accounts();
		for(; ai.current(); ++ai) {
			EbQtLocalAccount * l = (*ai)->localAccount();
			localAccounts.findRef(l);
			if (! localAccounts.current()) {
				localAccounts.append(l);
				fromCB->insertItem(l->name());
				updateLocalAcctItem(l);
				connect(l, SIGNAL(itemNeedsUpdate(EbQtLocalAccount *)),
					SLOT(updateLocalAcct(EbQtLocalAccount *)));
			}
			accounts.append(*ai);
			toCB->insertItem((*ai)->name());
			updateAccountItem(*ai);
			disconnect(*ai, 0, this, 0);
			connect(*ai, SIGNAL(itemNeedsUpdate(EbQtAccount *)),
				SLOT(updateAccount(EbQtAccount *)));
		}
	}
	fromCB->setEnabled(fromCB->count() > 0);
	fromLabel->setEnabled(fromCB->count() > 0);
	toCB->setEnabled(toCB->count() > 0);
	toLabel->setEnabled(toCB->count() > 0);
	if (toCB->count() > 0)
		toCB->setCurrentItem(0);
	fromCB->blockSignals(FALSE);
	toCB->blockSignals(FALSE);
	
	if (! singleContact) return;
	
	if (prevLocal && prevAccount) {
		localAccounts.findRef(prevLocal);
		accounts.findRef(prevAccount);
		if (localAccounts.current() && accounts.current())
			setCurrents();  // to ptrlist current pointers
		return;
	}
	EbQtAccount * a = singleContact->pickAccount();
	if (a)
		setCurrents(a->localAccount(), a);
	else  // no accounts, do the disabling thang
		updateAccounts();
}

void EbQtConv::updateAccounts()
{
	disconnect(sendButton, SLOT(setEnabled(bool)));
	if (fromCB->count() < 1 || toCB->count() < 1) {
		sendButton->setEnabled(FALSE);
		setLocalAcct(NULL);
		account = NULL;
		return;
	}
	account = accounts.at(toCB->currentItem());
	if (account->service()->canOffline()
		&& account->localAccount()->ready()) {
		sendButton->setEnabled(TRUE);
		return;
	}
	sendButton->setEnabled(account->isOnline());
	connect(account, SIGNAL(onlineChanged(bool)),
		sendButton, SLOT(setEnabled(bool)));
}

void EbQtConv::updateLocalAcct(EbQtLocalAccount * l)
{
	updateLocalAcctItem(l);
	if (! l->ready() && ! l->service()->canOffline()) {
		EbQtAccount * a = singleContact->pickAccount();
		if (a && a != account)
			setCurrents(a->localAccount(), a);
	}
	updateAccounts();
}

void EbQtConv::updateLocalAcctItem(EbQtLocalAccount * l)
{
	localAccounts.findRef(l);
	if (! localAccounts.current()) return;
	fromCB->changeItem(
		l->service()->pixmap(16,16, ! l->ready()),
		l->name(),  // TODO: status?
		localAccounts.at());
}
void EbQtConv::removeLocalAccount(EbQtLocalAccount * l)
{
	disconnect(l, 0, this, 0);
	localAccounts.findRef(l);
	if (! localAccounts.current()) return;
	int idx = localAccounts.at();
	localAccounts.remove(idx);
	fromCB->removeItem(idx);
	QPtrListIterator<EbQtAccount> ai(accounts);
	for(; ai.current(); ++ai) {
		if (l == (*ai)->localAccount()) {
			qWarning("conv: remove local acct which was in use!");
			removeAccount(*ai);
		}
	}
	updateAccounts();
}

void EbQtConv::updateAccount(EbQtAccount * a)
{
	updateAccountItem(a);
	if (! a->isOnline() && ! a->service()->canOffline()) {
		EbQtAccount * b = singleContact->pickAccount();
		if (b && b != a)
			setCurrents(b->localAccount(), b);
	}
	updateAccounts();
}

void EbQtConv::updateAccountItem(EbQtAccount * a)
{
	accounts.findRef(a);
	if (! accounts.current()) return;
	bool online = (a->status() == EbQtAccount::Online);
	QString status = a->statusMsg().isEmpty()
		? EbQtAccount::statusDesc(a->status())
		: a->statusMsg();
	QString text = (online && a->statusMsg().isEmpty())
		? QString(a->name())
		: QString("%1 %2").arg(a->name()).arg(  // don't double-bracket
			QRegExp("^\\s*[\\[\\(].*[\\)\\]]\\s*$").exactMatch(status)
				? status
				: (QString("(%1)").arg(status)));
	toCB->changeItem(a->service()->pixmap(16,16, ! online),
		text, accounts.at());
}

void EbQtConv::removeAccount(EbQtAccount * a)
{
	disconnect(a, 0, this, 0);
	accounts.findRef(a);
	if (! accounts.current()) return;
	int idx = accounts.at();
	accounts.remove(idx);
	toCB->removeItem(idx);

	EbQtLocalAccount * maybeUseless = a->localAccount();
	QPtrListIterator<EbQtAccount> ai(accounts);
	for(; ai.current(); ++ai) {
		if (maybeUseless == (*ai)->localAccount())
			return;
	}
	removeLocalAccount(maybeUseless);
	updateAccounts();
}

void EbQtConv::fromChanged(int from)
{
	setLocalAcct(localAccounts.at(from));
	for (unsigned int i=0; i<accounts.count(); i++) {
		if (accounts.at(i)->localAccount() == localAccount) {
			toCB->blockSignals(TRUE);
			toCB->setCurrentItem(i);
			account = accounts.at(i);
			toCB->blockSignals(FALSE);
			break;
		}
	}
	updateAccounts();
}
void EbQtConv::toChanged(int to)
{
	account = accounts.at(to);
	for (unsigned int i=0; i<localAccounts.count(); i++) {
		if (account->localAccount() == localAccounts.at(i)) {
			fromCB->blockSignals(TRUE);
			fromCB->setCurrentItem(i);
			setLocalAcct(localAccounts.at(i));
			fromCB->blockSignals(FALSE);
			break;
		}
	}
	updateAccounts();
}

bool EbQtConv::setCurrents(EbQtLocalAccount * l, EbQtAccount * a)
{
	if (l) localAccounts.findRef(l);
	if (a) accounts.findRef(a);
	if (! localAccounts.current() || ! accounts.current())
		return FALSE;
	fromCB->blockSignals(TRUE);
	toCB->blockSignals(TRUE);
	fromCB->setCurrentItem(localAccounts.at());
	toCB->setCurrentItem(accounts.at());
	fromCB->blockSignals(FALSE);
	toCB->blockSignals(FALSE);
	
	setLocalAcct(localAccounts.current());
	account = accounts.current();
	updateAccounts();
	return TRUE;
}

void EbQtConv::trySend()
{
	if (! sendButton->isEnabled()) return;
	QString text = sendEdit->text();
	// need at least one non-whitespace character
	if (text.find(QRegExp("\\S")) < 0) return;
	if (groupMode) {
		if (! localAccount) {
			qWarning("conv: trySend in group mode w/o local account! bug!!!");
			return;
		}
		emit(wantsGroupSend(text, id()));
	} else {
		if (! localAccount || ! account) {
			qWarning("conv: trySend in single mode w/o both accounts! bug!!!");
			return;
		}
		emit(wantsToSend(localAccount, account, text));
	}
	sendEdit->clear();
}

void EbQtConv::sentMsg(EbQtLocalAccount * l, EbQtAccount * a,
	const QString & msg, int secsAgo)
{
	if (! setCurrents(l, a)) return;
	addMessage(l->name(),  // TODO: aliases (this is handle)
		cookSent(msg),
		secsAgo,
		//l->service()->colour(),
		Qt::blue, Qt::blue);
}
void EbQtConv::sent3rd(EbQtLocalAccount * l, EbQtAccount * a,
	const QString & action, int secsAgo)
{
	// this fn is _NEVER USED_ atm, they're ALL recv3rd
	// (since 3rd is partly server-rendered atm)
	if (! setCurrents(l, a)) return;
	addMessage(l->name(),  // TODO: aliases (this is handle)
		action,
		secsAgo,
		//l->service()->colour(),
		QColor(), // null
		Qt::blue,
		TRUE /* third person */);
}
void EbQtConv::recvMsg(EbQtLocalAccount * l, EbQtAccount * a,
	const QString & msg, int secsAgo)
{
	if (! setCurrents(l, a)) return;
	addMessage(singleContact->name(),
		msg,
		secsAgo,
		l->service()->colour(), Qt::red);
	maybeFlash();
}
void EbQtConv::recv3rd(EbQtLocalAccount * l, EbQtAccount * a,
	const QString & action, int secsAgo)
{
	// *** UGH... ***
	/*if (!*/ setCurrents(l, a)/*) return*/;
	addMessage("",  // singleContact->name(),
		action,
		secsAgo,
	//	l->service()->colour(),
		QColor(), // null
	//	Qt::red,
		QColor(), //Qt::gray,
		TRUE  // third person
	);
	maybeFlash();
}
void EbQtConv::sentGroupMsg(const QString & msg)
{
	if (! groupMode) return;
	addMessage(localAccount->name(),  // TODO: aliases (this is handle)
		cookSent(msg),
		0,
		//l->service()->colour(),
		Qt::blue, Qt::blue);
}
void EbQtConv::recvGroupMsg(const QString & from, const QString & msg)
{
	addMessage(from, msg, 0,
		localAccount->service()->colour(), Qt::red);
	maybeFlash();
}
void EbQtConv::recvGroup3rd(const QString & msg)
{
	if (! groupMode) return;
	addMessage("",  // from,
		msg,
		0, QColor(), QColor(), TRUE);
	maybeFlash();
}

QString EbQtConv::cook(QString text)
{
	// eb-lite will make its html valid and safe now
	return text;
}

QString EbQtConv::cookSent(QString text)
{
	// sent text is thrown right back at us as-is, the only problem is newlines:
	// allow (convert to br) newlines not accompanied by some other newline generator
	for (int pos=0; pos<(int)(text.length()); pos++) {
		pos = text.find('\n',pos);
		if (pos < 0) break;
		if (text.left(pos).find(QRegExp("<(br(?: /)?|/p|/div|/li)>$",
			FALSE)) < 0) {
			text.insert(pos, "<br />");
			pos += 6;  // point at same newline to skip to next one
		}
	}
	return text;
}

void EbQtConv::addMessage(const QString & from,
	const QString & rawText,
	int secsAgo,
	const QColor & colour,
	const QColor & tsColour,
	bool thirdPerson)
{
	addLine(
//#ifdef EBQT_CONV_USE_TABLE
//		// cellspacing and cellpadding don't work in QTextEdit
//		"<table border=0>"
//		"<tr><td align=left valign=top>"
//#endif
		"<p style=\"margin-left:30px;text-indent:--20px\">"
		"<font color=\""
		+ tsColour.name() /*#rrggbb*/
		+ "\"><ts>("
		+ QTime::currentTime().addSecs(-secsAgo).toString()
		+ ") </ts></font>"
//#ifdef EBQT_CONV_USE_TABLE
//		"</td>" +
////		(from.isEmpty() || noNickColumn
////			? "<td colspan=2 width=\"*\" align=left valign=top>"
////			: "<td align=right valign=top>")
//
//		"<td width=\"*\" align=left valign=top>"
//#endif
		// this doesn't work in QTextEdit!
		//+ "<div style=\"margin-left:4em; text-indent:-4em\">"

		+ (from.isEmpty() ? QString::null :
			"<font color=\"" + colour.name() + "\"><b>"  // #rrggbb
			+ from + (thirdPerson ? "" : ":") +
			"</b></font>"
		) +
		
//#ifdef EBQT_CONV_USE_TABLE
//		(thirdPerson ? "" :
//		noNickColumn ? "</td></tr><tr><td></td><td></td>"
//			"<td width=\"*\" align=left valign=top>" :
//		"</td><td width=\"*\" align=left valign=top>")
//
//		(thirdPerson ? "" : noNickColumn ? " " :
//		"</td><td width=\"*\" align=left valign=top>")
//#else
		" "
//#endif // EBQT_CONV_USE_TABLE
		+ cook(rawText) +

		//"</div>" +
//#ifdef EBQT_CONV_USE_TABLE
//		"</td></tr>"
//		"</table>"
//#else
		"</p>"
//#endif // EBQT_CONV_USE_TABLE
		//"<br>\n\n"
		);
}

void EbQtConv::addLine(const QString & line)
{
//	QString newText = recvEdit->text();
//#ifdef EBQT_CONV_USE_TABLE
//	pos = newText.findRev("</table>", -1, FALSE);
//	if (pos < 0) { // not found
//		newText += "<table border=0>\n\n</table>";
//		pos = 18;
//	}
//#endif // EBQT_CONV_USE_TABLE
//	int pos = newText.length();
//
//	newText.insert(pos, line);
	bool wasNearBottom = recvEditNearBottom();
//	recvEdit->setText(newText);
	// I've tried append, it seems to mess with paras and kill ts...
	recvEdit->setText(recvEdit->text() + line);
	if (wasNearBottom)
		recvEditToBottom();
}

bool EbQtConv::eventFilter(QObject * o, QEvent * e)
{
	if (o == sendEdit->textEdit && e->type() == QEvent::KeyPress) {
		QKeyEvent * k = (QKeyEvent *) e;
		// Return, not Shift+Return or anything else + Return
		if (k->key() == Qt::Key_Return && k->state() == Qt::NoButton) {
			k->accept();
			trySend();
			return TRUE;  // hide this from sendEdit
		}
	}
	return EbQtConvUI::eventFilter(o, e);
}

void EbQtConv::keyPressEvent(QKeyEvent * k)
{
	if (k->key() == Qt::Key_Escape)
		tryClose();
}

bool EbQtConv::recvEditNearBottom()
{
	QScrollBar * s = recvEdit->verticalScrollBar();
	return (s->value() >= (s->maxValue()*3)/5);  // >= for 0
}

void EbQtConv::recvEditToBottom()
{
	recvEdit->sync();
	qApp->processEvents(100);
	recvEdit->scrollToBottom();
}

void EbQtConv::moveEvent(QMoveEvent *)
{
	if (singleContact)
		geoChangeTimer->start(1000, TRUE);
}
void EbQtConv::resizeEvent(QResizeEvent *)
{
	if (singleContact)
		geoChangeTimer->start(1000, TRUE);
	if (recvEditNearBottom())
		recvEditToBottom();
}

void EbQtConv::setIgnore(bool ignored)
{
	ignoredSet(! ignored);
	if (! singleContact) return;
	emit(wantsIgnore(singleContact));
}
void EbQtConv::ignoredSet(bool ignored)
{
	ignoreButton->blockSignals(TRUE);
	ignoreButton->setOn(ignored);
	ignoreButton->blockSignals(FALSE);
}

void EbQtConv::showTimeStamps(bool on)
{
	bool wasNearBottom = recvEditNearBottom();
	timeStamps->setDisplayMode(on
		? QStyleSheetItem::DisplayInline
		: QStyleSheetItem::DisplayNone);
	QString c = recvEdit->text(); recvEdit->clear(); recvEdit->setText(c);
	if (wasNearBottom)
		recvEditToBottom();
}

void EbQtConv::showCombos(bool on)
{
	if (singleContact && on)
		singleAcctsFrame->show();
	else
		singleAcctsFrame->hide();
	updateGeometry();
}

void EbQtConv::addGroupUser(const QString & handle, bool /*quiet*/)
{
	if (! groupMode) return;  if (handle.isEmpty()) return;
	if (groupItems[handle]) {
		qWarning("conv: rejecting duplicate group chat user");
		return;
	}
	updateGroupUserItem(handle);
	updateUsers();
/*	if (! quiet) {
		QColor c = localAccount->service()->colour();
		addMessage(QString::null,
			"<font color=\"" + c.light(160).name() + "\">&gt;</font>"
			"<font color=\"" + c.light(140).name() + "\">&gt;</font>"
			"<font color=\"" + c.light(120).name() + "\">&gt;</font>"
			" <font color=\"" + c.name() + "\"><b>" + handle
			+ " has joined</b></font>",
			0, QColor(), c, TRUE);
	}
*/
}

void EbQtConv::updateGroupUserItem(const QString & handle, bool removing)
{
	int pos = -1;
	QListBoxPixmap * item = groupItems.take(handle);
	if (item) {
		pos = usersBox->index(item);
		delete item;
	}
	QPixmap blob(16,16);  // TODO: proper dimensions
	QString lShortName = localAccount->name();
	int atPos = lShortName.findRev('@');
	if (atPos > 0) lShortName.truncate(atPos);
	if (localAccount &&
		(handle == localAccount->name() || handle == lShortName))
		blob = *(fromLabel->pixmap());
	else if (! removing && localAccount && localAccount->account(handle))
		blob = localAccount->service()->pixmap(
			blob.width(),blob.height());
	else
		blob.setMask(QBitmap(blob.width(),blob.height(), TRUE));
	item = new QListBoxPixmap(blob, handle);
	groupItems.insert(handle, item);
	usersBox->insertItem(item, pos);
}

void EbQtConv::removeGroupUser(const QString & handle, bool /*quiet*/)
{
	if (! groupMode) return;
	QListBoxPixmap * item = groupItems.take(handle);
	if (! item) {
		qWarning("conv: can't find item to remove");
		return;
	}
	delete item;
	updateUsers();
/*	if (! quiet) {
		QColor c = localAccount->service()->colour();
		addMessage(QString::null,
			"<font color=\"" + c.light(160).name() + "\">&lt;</font>"
			"<font color=\"" + c.light(140).name() + "\">&lt;</font>"
			"<font color=\"" + c.light(120).name() + "\">&lt;</font>"
			" <font color=\"" + c.name() + "\"><b>" + handle
			+ " has left</b></font>",
			0, QColor(), c, TRUE);
	}
*/
}

void EbQtConv::tryInviteOther()
{
	qDebug("other");
	bool ok;
	QString handle = QInputDialog::getText(tr("Invite user"),
		tr("Please give the handle of the user to invite"),
		QLineEdit::Normal, QString::null, &ok, this);
	if (! ok) return;
	if (handle.isEmpty()) return;
	emit(wantsGroupInvite(handle, id()));
}

void EbQtConv::tryClose()
{
	if (groupMode) {
		if (! isEnabled()) return;
		setEnabled(FALSE);
		emit(wantsGroupLeave(id()));
	} else {
		canClose = TRUE;
		emit(convClosing(this));
	}
}
void EbQtConv::closeEvent(QCloseEvent * ce)
{
	if (canClose) {
		if (! groupMode)
			emit(convClosing(this));
		ce->accept();
	} else {
		tryClose();
		ce->ignore();
	}
}

void EbQtConv::updateUsers()
{
	usersCount->display((int)(usersBox->count()));
//	usersBox->setMinimumSize(usersBox->minimumSize().width(),
//		usersBox->maxItemWidth());	
}

void EbQtConv::tryChatAction(int i)
{
	if (! (groupMode && localAccount)) return;
	emit(wantsChatAction(
		localAccount->service()->groupChatActions[i],
		id(), localAccount));
}

void EbQtConv::tryChatUserAction(int userAndAction)
{
	if (! (groupMode && localAccount)) return;
	QStringList actions = localAccount->service()->groupUserActions;
	emit(wantsChatUserAction(
		usersBox->text(userAndAction / actions.count()),
		actions[userAndAction % actions.count()], id()));
}

void EbQtConv::usersRMB(QListBoxItem * i, const QPoint & pos)
{
	if (! (groupMode && localAccount && i)) return;
	emit(wantsChatUserMenu(i->text(), usersBox->index(i), pos, this));
}

void EbQtConv::usersDblClick(QListBoxItem * i)
{
	if (! (groupMode && localAccount && i)) return;
	emit(wantsOpenConv(i->text(), this));
}

void EbQtConv::popupInvite()
{
	if (! inviteMenu) return;
	inviteMenu->clear();
	if (! localAccount) return;
	QPtrList<EbQtAccount> accts;
	for (QDictIterator<EbQtAccount> it = localAccount->accounts();
		it.current(); ++it)
		accts.append(*it);
	if (accts.count() <= 0) return;
	for (unsigned int i=0; i < accts.count(); i++) {
		if (accts.at(i)->status() == EbQtAccount::Offline) continue;
		EbQtContact * c = accts.at(i)->contact();
		inviteMenu->insertItem(accts.at(i)->service()->pixmap(16,16,
			accts.at(i)->status() != EbQtAccount::Online),
			QString("%1 (%2)").arg(c->name())
			.arg(c->group()->name()), i);
	}
	if (inviteMenu->count() > 0) {
		inviteMenu->insertSeparator();
		inviteMenu->insertItem(tr("Other..."), this, SLOT(tryInviteOther()));
		int r = inviteMenu->exec(invite->mapToGlobal(
			QPoint(0, invite->height())));
		if (r >= 0 && (unsigned int) r < accts.count())  // account item
			emit(wantsGroupInvite(accts.at(r)->name(), id()));
	} else {
		tryInviteOther();
	}
}

void EbQtConv::popupActions()
{
	if (! actionsMenu) return;
	actionsMenu->exec((groupMode ? chatAction : sglAction)->mapToGlobal(
		QPoint(0, actionsMenu->height())));
}

void EbQtConv::tryAddFromGroup(int user)
{
	if (! (groupMode && localAccount)) return;
	emit(wantsAdd(usersBox->text(user), localAccount, this));
}

void EbQtConv::setLocalAcct(EbQtLocalAccount * l)
{
	if (localAccount) 
		disconnect(localAccount, 0, this, 0);
	localAccount = l;
	if (localAccount) {
		connect(localAccount,
			SIGNAL(accountAdded(EbQtAccount *, EbQtLocalAccount *)),
			SLOT(addedAccount(EbQtAccount *)));
		connect(localAccount,
			SIGNAL(accountRemoving(EbQtAccount *, EbQtLocalAccount *)),
			SLOT(removingAccount(EbQtAccount *)));
	}
}

void EbQtConv::addedAccount(EbQtAccount * a)
{
	if (! groupMode) return;
	if (groupItems[a->name()])
		updateGroupUserItem(a->name());
}
void EbQtConv::removingAccount(EbQtAccount * a)
{
	if (! groupMode) return;
	if (groupItems[a->name()])
		updateGroupUserItem(a->name(), TRUE);
}

void EbQtConv::focusSendEdit()
{
	// doing this immediately or just using sendEdit doesn't work
	// (due to issues with embedding, or something)
	QTimer::singleShot(0, sendEdit->textEdit, SLOT(setFocus()));
}

/** flashes the icon a number of times, use 0 for forever, and 1 to end that */
void EbQtConv::flash(unsigned int times)
{
	static unsigned int timesLeft = 0;
	static bool invert = false;
	
	if (timesLeft == 0) {
		timesLeft = times;
	}
	if (timesLeft == 1) {
		flashTimer->stop();
		setTempIcon(cleanIcon);
	} else {
		setTempIcon(QPixmap(cleanIcon).xForm(QWMatrix().rotate(
			invert ? 15 : -15)));
		invert = ! invert;
		flashTimer->start(250, true);
	}
	if (timesLeft > 0)
		timesLeft--;
}

void EbQtConv::focusInEvent(QFocusEvent *)
{
	flash(1);  // stop
}
void EbQtConv::enterEvent(QEvent *)
{
	flash(1);  // stop
}

void EbQtConv::maybeFlash()
{
	// must work for both tabbed and non-tabbed
	QWidget * fw = qApp->focusWidget();
	if (! isVisible() || ! fw
		|| fw->topLevelWidget() != topLevelWidget())
		flash(0);  // inf
}

