/***************************************************************************
                                ebqtcontact.h
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTCONTACT_H
#define EBQTCONTACT_H

class QAction;

#include <qobject.h>
#include <qptrlist.h>		// accounts
#include <qstringlist.h>	// actions

class EbQtGroup;

#include "ebqt.h"
#include "ebqtaccount.h"	// we have sub-items

/**
  * EbQtContact is an Everybuddy contact, i.e. a real person, holding a list
  * of accounts.
  * The contact name is QObject::name()
  *
  * @author Chris Boyle
  */
class EbQtContact : public QObject
{
	Q_OBJECT

public: 
	EbQtContact(EbQtGroup * group, const QString & name);
	~EbQtContact();
	EbQtGroup * group() { return (EbQtGroup *)parent(); }
	QPtrListIterator<EbQtAccount> accounts() {
		return QPtrListIterator<EbQtAccount>(acctList); }
	QString name() const { return contactName; }
	bool isOnline() const { return lastStatus > EbQtAccount::Offline; }
	QString statusMsg() const { return lastStatusMsg; }
	EbQtAccount::AccountStatus status() const { return lastStatus; }
	EbQtAccount * pickAccount() const { return maxAccount; }
	bool ignored() const { return isIgnored; }
	QString ignoreMsg() const { return lastIgnoreMsg; }
	static QStringList actions;

public slots:
	void addAccount(EbQtAccount * account, bool makeFirst = FALSE);
	void takeAccount(EbQtAccount * account);
	void updateAcctsOnline();
	void setIgnored(bool ignored, QString msg);
	void tryIgnore(bool on) { emit(wantsIgnore(on, this)); }
	void tryToggleIgnore() { tryIgnore(! ignored()); }
	void setName(const QString & name);
	void tryMoveTo(EbQtGroup * group);
	void moveTo(EbQtGroup * group);
	void startRename() { emit(wantsRenameStart(this)); }
	void remove() { emit(wantsRemove(this)); }
	void tryOpenConv() { emit(wantsOpenConv(this)); }
	void tryAction(int which) { emit(wantsAction(which, this)); }

signals:
	void statusChanged(EbQtAccount::AccountStatus oldStatus, EbQtContact * c);
	void statusChanged(EbQtContact * c);
	void onlineChanged(bool online, EbQtContact * c);
	void itemNeedsUpdate(EbQtContact * c);
	void nameChanged(const QString & name, EbQtContact * c);
	void wantsRenameStart(EbQtContact * c);
	void wantsOpenConv(EbQtContact * c);
	void wantsRemove(EbQtContact * c);
	void wantsIgnore(bool on, EbQtContact * c);
	void wantsToMoveTo(const QString & group, EbQtContact * c);
	void lostAccount(EbQtAccount * a);
	void ignoredChanged(bool ignored);
	void wantsAction(int which, EbQtContact * c);

private:
	QString contactName;
	QPtrList<EbQtAccount> acctList;
	EbQtAccount * maxAccount;
	EbQtAccount::AccountStatus lastStatus;
	QString lastStatusMsg;
	QString lastIgnoreMsg;
	bool isIgnored;
};

#endif
