/***************************************************************************
                          ebqtcontact.cpp  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include "ebqtcontact.h"
#include "ebqtgroup.h"  // parent
#include "ebqtservice.h"  // inspecting offline capabilities

#include <qaction.h>

QStringList EbQtContact::actions;

EbQtContact::EbQtContact(EbQtGroup * group, const QString & name) :
	QObject(group),
	maxAccount(NULL),
	lastStatus(EbQtAccount::Offline),
	lastStatusMsg(EbQtAccount::statusDesc(lastStatus)),
	isIgnored(FALSE)
{
	setName(name);
	group->addContact(this);
}

EbQtContact::~EbQtContact()
{
	group()->takeContact(this);
}

void EbQtContact::addAccount(EbQtAccount * account, bool makeFirst)
{
	connect(account, SIGNAL(statusChanged()), SLOT(updateAcctsOnline()));
	if (makeFirst)
		acctList.insert(0, account);
	else
		acctList.append(account);
	updateAcctsOnline();
}

void EbQtContact::takeAccount(EbQtAccount * account)
{
	disconnect(account, 0, this, 0);
	acctList.find(account);
	if (acctList.current())
		acctList.take();
	emit(lostAccount(account));
	updateAcctsOnline();
}

void EbQtContact::updateAcctsOnline()
{
	EbQtAccount::AccountStatus maxStatus = EbQtAccount::Offline;
	QString anyMaxMsg = "";
	maxAccount = (acctList.count() > 0) ? acctList.first() : NULL;
	
	// get the max status, and the first custom message on something with
	// that status, or else the generic description of that status
	QPtrListIterator<EbQtAccount> ai(acctList);
	EbQtAccount::AccountStatus currentStatus;
	for (; ai.current(); ++ai) {
		currentStatus = (*ai)->status();
		if (currentStatus > maxStatus) {
			maxStatus = currentStatus;
			anyMaxMsg = (*ai)->statusMsg();
			maxAccount = (*ai);
		} else if (currentStatus == maxStatus
			&& anyMaxMsg.isEmpty()) {
			anyMaxMsg = (*ai)->statusMsg();
		}
	}
	if (anyMaxMsg.isEmpty()/* && maxStatus==EbQtAccount::Offline*/) {  // breaks status bar
		anyMaxMsg = EbQtAccount::statusDesc(maxStatus);
	}
	
	// if it's all offline, pick the first one with offline messaging
	if (maxStatus <= EbQtAccount::Offline) {
		for (; ai.current(); ++ai) {
			if ((*ai)->service()->canOffline()) {
				maxAccount = (*ai);
			}
		}
	}
	
	bool cameOn = FALSE, wentOff = FALSE, statusNew = FALSE;
	if (maxStatus > EbQtAccount::Offline
		&& lastStatus <= EbQtAccount::Offline)
		cameOn = TRUE;
	else if (maxStatus <= EbQtAccount::Offline
		&& lastStatus > EbQtAccount::Offline)
		wentOff = TRUE;
	EbQtAccount::AccountStatus old = lastStatus;
	if (lastStatus != maxStatus) {
		statusNew = TRUE;  // wait til msg and others changed
		lastStatus = maxStatus;
	}
	lastStatusMsg = anyMaxMsg;
	// even if we haven't changed status we may have changed accounts
	emit(itemNeedsUpdate(this));
	if (statusNew) {
		emit(statusChanged(old, this));
		emit(statusChanged(this));
	}
	if (cameOn)
		emit(onlineChanged(TRUE, this));
	else if (wentOff)
		emit(onlineChanged(FALSE, this));
}

void EbQtContact::setIgnored(bool ignored, QString msg)
{
	bool changed = (ignored != isIgnored);
	isIgnored = ignored;
	lastIgnoreMsg = msg;
	if (changed) emit(ignoredChanged(isIgnored));
}

void EbQtContact::setName(const QString & name)
{
	if (name == contactName) return;
	emit(nameChanged(name, this));
	contactName = name;
	QObject::setName(QString("contact %1").arg(name));
}

void EbQtContact::tryMoveTo(EbQtGroup * group)
{
	if (group == this->group()) return;
	emit(wantsToMoveTo(group->name(), this));
}

void EbQtContact::moveTo(EbQtGroup * group)
{
	this->group()->takeContact(this);
	group->insertChild(this);
	group->addContact(this);
}

