/***************************************************************************
                          ebqtbuddyview.h  -  description
                             -------------------
    begin                : Fri Jan 24 2003
    copyright            : (C) 2002-2004 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTBUDDYVIEW_H
#define EBQTBUDDYVIEW_H

class QMimeSource;
class QDropEvent;

#include <qdragobject.h>
#include <qlistview.h>

class EbQtGroup;
class EbQtContact;
class EbQtLocalAccount;
class EbQtService;
class EbQtAccount;

/**
  *@author Chris Boyle
  */

class EbQtBuddyView : public QListView  {
	Q_OBJECT

public: 
	EbQtBuddyView(QWidget * parent = 0, const char * name = 0);
	~EbQtBuddyView();

protected:
	void resizeEvent(QResizeEvent * e);
	void showEvent(QShowEvent * e);
	void resizeColumns();
	virtual QDragObject * dragObject();
};

class EbQtBuddyViewItem : public QListViewItem {
public:
	EbQtBuddyViewItem(EbQtBuddyView * parent, QString label, EbQtGroup * owner);
	EbQtBuddyViewItem(EbQtBuddyView * parent, EbQtBuddyViewItem * after,
		QString label, EbQtGroup * owner);
	EbQtBuddyViewItem(EbQtBuddyViewItem * parent, QString label, QObject * owner);
	EbQtBuddyViewItem(EbQtBuddyViewItem * parent, EbQtBuddyViewItem * after,
		QString label, QObject * owner);
	~EbQtBuddyViewItem();
	QObject * owner() const;
	bool acceptDrop(const QMimeSource * mime) const;

protected:
	void dropped(QDropEvent * e);

private:
	QObject * mOwner;
};


/**
  *  a local-only drag of buddy list objects
  */
class EbQtBuddyViewDrag : public QDragObject {
	Q_OBJECT
public:
	EbQtBuddyViewDrag(EbQtGroup * group, EbQtContact * contact,
		EbQtLocalAccount * local, EbQtService * service, EbQtAccount * account,
		QWidget * dragSource, const char * name = 0);
	~EbQtBuddyViewDrag();
	const char * format(int i) const;
	bool provides(const char * format) const;
	QByteArray encodedData(const char * format) const;
	static bool canDecode(const QMimeSource * mime);
	static bool decode(const QMimeSource * mime, EbQtGroup * & group, EbQtContact * & contact,
		EbQtLocalAccount * & local, EbQtService * & service, EbQtAccount * & account);

private:
	QCString fmt;
	EbQtGroup * group;
	EbQtContact * contact;
	EbQtLocalAccount * local;
	EbQtService * service;
	EbQtAccount * account;
};

#endif
