/***************************************************************************
                          ebqtbuddyview.cpp  -  description
                             -------------------
    begin                : Fri Jan 24 2003
    copyright            : (C) 2002-2004 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include <qdragobject.h>
#include <qheader.h>
#include <qevent.h>
#include <qmessagebox.h>  // FIXME: temp!

#include "ebqtbuddyview.h"
#include "ebqtgroup.h"
#include "ebqtcontact.h"
#include "ebqtlocalaccount.h"
#include "ebqtservice.h"
#include "ebqtaccount.h"

EbQtBuddyView::EbQtBuddyView(QWidget * parent, const char * name) :
	QListView(parent, name)
{
	addColumn("Buddy");
	addColumn("Status");
	header()->setClickEnabled(FALSE);
	header()->setMovingEnabled(FALSE);
	header()->setResizeEnabled(FALSE);
	header()->setResizeEnabled(TRUE, 0);
	setColumnWidthMode(0, Maximum);
	setResizeMode(AllColumns);
	setSorting(-1);  // no sorting
	setRootIsDecorated(TRUE);
	setAllColumnsShowFocus(TRUE);
	setDragAutoScroll(TRUE);
	viewport()->setAcceptDrops(TRUE);
	resizeColumns();
}

EbQtBuddyView::~EbQtBuddyView()
{
}

void EbQtBuddyView::resizeEvent(QResizeEvent * e)
{
	QListView::resizeEvent(e);
	if (e->oldSize().width() > width())
		resizeColumns();
}
void EbQtBuddyView::showEvent(QShowEvent * e)
{
	resizeColumns();
	QListView::showEvent(e);
}
void EbQtBuddyView::resizeColumns()
{
	setColumnWidth(1, viewport()->width()/4);
	setColumnWidth(0, viewport()->width()*3/4);
}

QDragObject * EbQtBuddyView::dragObject()
{
	// FIXME: assumption... nobody ever puts other items in there...
	EbQtBuddyViewItem * i = (EbQtBuddyViewItem *)selectedItem();
	if (! i) return 0;
	QObject * o = i->owner();
	if (! o) return 0;
	if (o->isA("EbQtContact")) {
		EbQtContact * c = (EbQtContact *)o;
		EbQtBuddyViewDrag * contactDrag =
			new EbQtBuddyViewDrag(c->group(), c, 0, 0, 0,
			this, "contactDrag");
		if (i->pixmap(0))
			contactDrag->setPixmap(*(i->pixmap(0)));
		return contactDrag;
	} else if (o->isA("EbQtAccount")) {
		EbQtAccount * a = (EbQtAccount *)o;
		EbQtBuddyViewDrag * accountDrag =
			new EbQtBuddyViewDrag(a->contact()->group(), a->contact(),
			a->localAccount(), a->service(), a,
			this, "accountDrag");
		if (i->pixmap(0))
			accountDrag->setPixmap(*(i->pixmap(0)));
		return accountDrag;
	} else {
		return 0;
	}
}


EbQtBuddyViewItem::EbQtBuddyViewItem(EbQtBuddyView * parent, QString label, EbQtGroup * owner) :
	QListViewItem(parent, label),
	mOwner(owner)
{
}
EbQtBuddyViewItem::EbQtBuddyViewItem(EbQtBuddyView * parent, EbQtBuddyViewItem * after,
	QString label, EbQtGroup * owner) :
	QListViewItem(parent, after, label),
	mOwner(owner)
{
}
EbQtBuddyViewItem::EbQtBuddyViewItem(EbQtBuddyViewItem * parent, QString label, QObject * owner) :
	QListViewItem(parent, label),
	mOwner(owner)
{
}
EbQtBuddyViewItem::EbQtBuddyViewItem(EbQtBuddyViewItem * parent, EbQtBuddyViewItem * after,
	QString label, QObject * owner) :
	QListViewItem(parent, after, label),
	mOwner(owner)
{
}

EbQtBuddyViewItem::~EbQtBuddyViewItem()
{
}

QObject * EbQtBuddyViewItem::owner() const
{
	return mOwner;
}

bool EbQtBuddyViewItem::acceptDrop(const QMimeSource * mime) const
{
	EbQtGroup * group;
	EbQtContact * contact;
	EbQtLocalAccount * local;
	EbQtService * service;
	EbQtAccount * account;
	if (! EbQtBuddyViewDrag::decode(mime, group, contact, local, service, account))
		return FALSE;
	if (! owner()) return FALSE;
	if (! (group && contact)) return FALSE;
	if (! (local || service || account)) {  // it's a contact
		if (! owner()->isA("EbQtGroup")) return FALSE;
		return (EbQtGroup *)owner() != group;
	} else if (local && service && account) {  // it's an account
		if (! owner()->isA("EbQtContact")) return FALSE;
		return (EbQtContact *)owner() != contact;
	} else {
		return FALSE;
	}
}

void EbQtBuddyViewItem::dropped(QDropEvent * e)
{
	EbQtGroup * group;
	EbQtContact * contact;
	EbQtLocalAccount * local;
	EbQtService * service;
	EbQtAccount * account;
	if (! EbQtBuddyViewDrag::decode(e, group, contact, local, service, account))
		return;
	if (! owner()) return;
	if (! (group && contact)) return;
	if (! (local || service || account)) {  // it's a contact
		if (! owner()->isA("EbQtGroup")) return;
		if ((EbQtGroup *)owner() == group) return;
		contact->tryMoveTo((EbQtGroup *)owner());
	} else if (local && service && account) {  // it's an account
		if (! owner()->isA("EbQtContact")) return;
		if ((EbQtContact *)owner() == contact) return;
		account->tryMoveTo((EbQtContact *)owner());
	}
}


#define EBQT_DRAG_MIME_TYPE "application/x-ebqt-gclsa"
EbQtBuddyViewDrag::EbQtBuddyViewDrag(EbQtGroup * group, EbQtContact * contact,
	EbQtLocalAccount * local, EbQtService * service, EbQtAccount * account,
	QWidget * source, const char * name) :
	QDragObject(source, name),
	fmt(EBQT_DRAG_MIME_TYPE),
	group(group), contact(contact),
	local(local), service(service), account(account)
{
}

EbQtBuddyViewDrag::~EbQtBuddyViewDrag()
{
}


const char * EbQtBuddyViewDrag::format(int i) const
{
	if (i > 0) return 0;
	return fmt;
}
bool EbQtBuddyViewDrag::provides(const char * format) const
{
	return qstricmp(format, fmt) == 0;
}

QByteArray EbQtBuddyViewDrag::encodedData(const char * format) const
{
	if (qstricmp(format, EBQT_DRAG_MIME_TYPE) != 0)
		return QByteArray(0);
	unsigned int ps = sizeof(void *);
	QByteArray data(5*ps);
	memcpy(data.data(),      &group,   ps);
	memcpy(data.data()+ps,   &contact, ps);
	memcpy(data.data()+ps*2, &local,   ps);
	memcpy(data.data()+ps*3, &service, ps);
	memcpy(data.data()+ps*4, &account, ps);
	return data;
}

bool EbQtBuddyViewDrag::canDecode(const QMimeSource * mime)
{
	return mime->provides(EBQT_DRAG_MIME_TYPE);
}

bool EbQtBuddyViewDrag::decode(const QMimeSource * mime,
	EbQtGroup * & group, EbQtContact * & contact,
	EbQtLocalAccount * & local, EbQtService * & service, EbQtAccount * & account)
{
	QByteArray data = mime->encodedData(EBQT_DRAG_MIME_TYPE);
	unsigned int ps = sizeof(void *);
	if (data.size() != 5*ps)
		return FALSE;
	memcpy(&group,   data.data(),      ps);
	memcpy(&contact, data.data()+ps,   ps);
	memcpy(&local,   data.data()+ps*2, ps);
	memcpy(&service, data.data()+ps*3, ps);
	memcpy(&account, data.data()+ps*4, ps);
	return TRUE;
}

