/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void EbQtAwayDlg::showEvent(QShowEvent *)
{
	titleEdit->setCursorPosition(titleEdit->text().length());
	titleEdit->selectAll();
	bodyEdit->moveCursor(QTextEdit::MoveEnd, FALSE);
	bodyEdit->selectAll();
}

QString EbQtAwayDlg::title()
{
	return titleEdit->text();
}

QString EbQtAwayDlg::body()
{
	return bodyEdit->text();
}

void EbQtAwayDlg::setTitle( const QString & text )
{
	titleEdit->setText(text);
}

void EbQtAwayDlg::setBody( const QString & text )
{
	bodyEdit->setText(text);
}

void EbQtAwayDlg::init()
{
#if (QT_VERSION >= 0x030100)
	bodyEdit->setTabChangesFocus(TRUE);
#endif
	bodyEdit->installEventFilter(this);
}

bool EbQtAwayDlg::eventFilter( QObject * o, QEvent * e )
{
	if (o == bodyEdit && e->type() == QEvent::KeyPress) {
		QKeyEvent * k = (QKeyEvent *) e;
		// Return, not Shift+Return or anything else + Return
		if (k->key() == Qt::Key_Return && k->state() == Qt::NoButton) {
			k->accept();
			accept();
			return TRUE;  // hide this from sendEdit
		}
	}
	return QDialog::eventFilter(o, e);
}
