/***************************************************************************
                          ebqtadd.h  -  description
                             -------------------
    begin                : Wed Dec 25 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTADD_H
#define EBQTADD_H

#include "ebqt.h"
#include "ebqtaddui.h"		// parent from Designer
#include "ebqtmainwin.h"	// tell the compiler EbQtMainWin isA QWidget

/**
  * the "add to buddy list" dialog for EbQt
  *
  * @author Chris Boyle
  */

class EbQtAdd : public EbQtAddUI  {
	Q_OBJECT

public:
	EbQtAdd(EbQtMainWin * parent,
		QDict<EbQtGroup> * allGroups,
		QDict<EbQtService> * allServices,
		const char * name=0);
	~EbQtAdd();

public slots:
	void refreshLocals();

signals:
	void wantsToAdd(const QString & group, const QString & contact,
		const QString & local, const QString & service,
		const QString & account);

private slots:
	void groupChanged(const QString & newGroup);
	void contactChanged(const QString & newContact);
	void accountChanged(const QString & newAccount);
	void serviceChanged(const QString & newService);
	void localChanged(const QString & newLocal);
	bool updateAccountEnabled();
	void updateAccounts();
	void updateAddEnabled();
	void tryAdd();

private:
	QDict<EbQtGroup> * allGroups;  // links to ones in mainwin
	QDict<EbQtService> * allServices;
};

#endif
