/***************************************************************************
                          ebqtadd.cpp  -  description
                             -------------------
    begin                : Wed Dec 25 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qdict.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtabwidget.h>

#include "ebqtadd.h"
#include "ebqtgroup.h"
#include "ebqtservice.h"
#include "ebqtcontact.h"
#include "ebqtaccount.h"
#include "ebqtlocalaccount.h"

EbQtAdd::EbQtAdd(EbQtMainWin * parent, QDict<EbQtGroup> * allGroups,
	QDict<EbQtService> * allServices, const char * name) :
	EbQtAddUI(parent,name),
	allGroups(allGroups),
	allServices(allServices)
{
	groupCB->blockSignals(TRUE);
	QDictIterator<EbQtGroup> gi(*allGroups);
	for (; gi.current(); ++gi)
		groupCB->insertItem(gi.currentKey());
	groupCB->clearEdit();
	groupCB->blockSignals(FALSE);

	serviceCB->blockSignals(TRUE);
	QDictIterator<EbQtService> si(*allServices);
	for (; si.current(); ++si)
		serviceCB->insertItem((*si)->pixmap(16,16), si.currentKey());
	serviceCB->blockSignals(FALSE);
	serviceChanged(serviceCB->currentText());

	// fill local combo on service changed, but open with it empty
	// (so it's clearer that you can use it to add one)
	if (parent->tabs->currentPageIndex() > 0)
		localCB->clearEdit();

	connect(parent, SIGNAL(buddyListChanged()),
		SLOT(updateAddEnabled()));
}

EbQtAdd::~EbQtAdd()
{
}

void EbQtAdd::groupChanged(const QString & newGroup)
{
	EbQtGroup * g;

	// enable contact box if there is a group
	bool e = ! (newGroup.isEmpty());
	contactCB	->setEnabled(e);
	contactLabel	->setEnabled(e);

	// if this group exists already, fill the autocompletes
//	QString prevContact = contactCB->currentText();
	contactCB->blockSignals(TRUE);
	contactCB->clear();
	if (e && (g = (*allGroups)[newGroup])) {
		QDictIterator<EbQtContact> ci = g->contacts();
		for (; ci.current(); ++ci)
			contactCB->insertItem(ci.currentKey());
	}

//	if (prevContact.isEmpty()) {
		if (contactCB->count() > 0) contactCB->setCurrentItem(0);
		// else no prev, none existing in group, leave empty
//	} else {
//		contactCB->setEditText(prevContact);
//	}
	contactCB->blockSignals(FALSE);
	contactChanged(contactCB->currentText());

	updateAddEnabled();
}
void EbQtAdd::contactChanged(const QString &)
{
	updateAccounts();  // depends on service+local too
	updateAddEnabled();  // we may have cleared the edit
}

void EbQtAdd::serviceChanged(const QString & newService)
{
	EbQtService * s;
//	QString prevLocal = localCB->currentText();
	localCB->blockSignals(TRUE);
	localCB->clear();
	if (newService.isEmpty() || ! (s = (*allServices)[newService])) {
		qWarning("addDlg: can't have service \"%s\"!", newService.ascii());
		localCB->setEnabled(FALSE);
		localLabel->setEnabled(FALSE);
		localCB->blockSignals(FALSE);
		return; // should really never ever happen
	}
	localCB->setEnabled(TRUE);
	localLabel->setEnabled(TRUE);

	for (QDictIterator<EbQtLocalAccount> li = s->localAccounts();
		li.current(); ++li)
		localCB->insertItem(li.currentKey());

//	if (prevLocal.isEmpty()) {
		if (localCB->count() > 0) localCB->setCurrentItem(0);
//	} else {
//		localCB->setEditText(prevLocal);
//	}
	localCB->blockSignals(FALSE);
	localChanged(localCB->currentText());  // will do updateAddEnabled()
}
void EbQtAdd::localChanged(const QString &)
{
	// if you change updateAccounts() back to respecting the local
	// account, you'll want updateAccounts() here
	accountCB->clearEdit();
	updateAccountEnabled();
	updateAddEnabled();  // we may have cleared the edit
}

void EbQtAdd::accountChanged(const QString &)
{
	updateAddEnabled();
}


bool EbQtAdd::updateAccountEnabled()
{
	bool e = ! (groupCB->currentText().isEmpty() || contactCB->currentText().isEmpty()
		|| serviceCB->currentText().isEmpty() || localCB->currentText().isEmpty());
	accountCB->blockSignals(TRUE);
	// don't kill the autocompletes, this may be the middle of editing localCB,
	// i.e. it'll get re-enabled very soon, and localCB won't put them back
	if (! e ) accountCB->clearEdit();
	accountCB->setEnabled(e);
	accountLabel->setEnabled(e);
	accountCB->blockSignals(FALSE);
	return e;
	// caller should do updateAddEnabled() now
}

void EbQtAdd::updateAccounts()
{
	// show all of contact's accounts, useful for similar usernames...
	EbQtGroup        * g;
	EbQtContact      * c;
	accountCB->clear();
	if (! updateAccountEnabled()) return;
	if (! (g = (*allGroups)[groupCB  ->currentText()])) return;
	if (! (c =  g->contact(contactCB->currentText()))) return;

	// we have a contact, so fill the account autocomplete
	accountCB->blockSignals(TRUE);
	QPtrListIterator<EbQtAccount> ai = c->accounts();
	for (; ai.current(); ++ai)
		accountCB->insertItem((*ai)->name());
	accountCB->clearEdit();
	accountCB->blockSignals(FALSE);
}

void EbQtAdd::updateAddEnabled()
{
	EbQtGroup	 * g = 0;
	EbQtContact	 * c = 0;
	EbQtService	 * s = 0;
	EbQtLocalAccount * l = 0;
	EbQtAccount      * a = 0;

	short whatsNew = 0;
	const short   groupNew = 1;
	const short contactNew = 2;
	const short   localNew = 4;
	// 8 reserved (something service related, like if svc becomes editable...?)
	const short    acctNew = 16;

	// maybe we could add a group and/or contact...
	if (! groupCB->currentText().isEmpty()) {
		if (! (g = (*allGroups)[groupCB->currentText()]))
			whatsNew |= groupNew;
		if (! contactCB->currentText().isEmpty()
			&& (! g || ! (c = g->contact(contactCB->currentText()))))
			whatsNew |= contactNew;
	}

	// for anything else, we need a valid service
	if (serviceCB->currentText().isEmpty())
		hintLabel->setText("There are no services. Maybe you should load some plugins.");
	else if (! (s = (*allServices)[serviceCB->currentText()]))
		hintLabel->setText("Service doesn't exist: please report this as a bug!");
	else {

		// could be adding a local acct...
		if (! localCB->currentText().isEmpty()
			&& ! (l = s->localAccount(localCB->currentText())))
			whatsNew |= localNew;
		// or a remote acct
		if (! groupCB->currentText().isEmpty()
			&& ! contactCB->currentText().isEmpty()
			&& ! localCB->currentText().isEmpty()
			&& ! accountCB->currentText().isEmpty()
			&& (! c || ! l || ! (a = l->account(accountCB->currentText())))) {
			whatsNew |= acctNew;
		}
	}

	addButton->setEnabled(whatsNew > 0);

	QStringList newThings;
	if (whatsNew &   localNew) newThings << "a local account";
	if (whatsNew &   groupNew) newThings << "a group";
	if (whatsNew & contactNew) newThings << "a contact";
	if (whatsNew &    acctNew) newThings << "an account";
	int count = newThings.count();
	QString hint;
	if (count == 0) hint = "Enter something new to add.";
	else {
		hint = "will add " + newThings[0];
		if (count > 1) {
			for (int i=1; i < count - 1; i++)
				hint += ", " + newThings[i];
			hint += " and " + newThings[count - 1];
		}
	}

	hintLabel->setText(hint);
}

void EbQtAdd::tryAdd()
{
	// sometimes we leave values in disabled controls to help people who
	// edit things which momentarily disable them (when the thing being
	// edited is momentarily null)
	// this is all well and good but we have to ignore disabled values here
	if (! contactCB->isEnabled()) contactCB->clearEdit();
	if (! localCB->isEnabled()) localCB->clearEdit();
	if (! accountCB->isEnabled()) accountCB->clearEdit();
	emit(wantsToAdd(groupCB->currentText(), contactCB->currentText(),
		localCB->currentText(), serviceCB->currentText(),
		accountCB->currentText()));
	//close();
}

void EbQtAdd::refreshLocals()
{
	serviceChanged(serviceCB->currentText());
}

