/***************************************************************************
                          ebqtaccount.h  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#ifndef EBQTACCOUNT_H
#define EBQTACCOUNT_H

#include <qobject.h>

class EbQtContact;
class EbQtService;
class EbQtLocalAccount;

#include "ebqt.h"
#include "ebqtlocalaccount.h"

/**
  * EbQtAccount is an account on one service (i.e. part of a contact)
  * The handle is QObject::name()
  *
  * @author Chris Boyle
  */
class EbQtAccount : public QObject {
	Q_OBJECT

public:
	EbQtAccount(EbQtContact * contact, EbQtLocalAccount * localAcct,
		const QString & name);  // local acct is parent
	~EbQtAccount();
	QString name() const { return handle; }
	EbQtContact * contact() const { return accContact; }
	EbQtLocalAccount * localAccount() const { return (EbQtLocalAccount *)parent(); }
	EbQtService * service() const;
	
	/** possible status values */
	enum AccountStatus {  // higher -> preferred for conv and contact status
		Offline,
		Away,  // away/online order DIFFERS from spec, catered for by recv
		Online };
	static const QString statusDesc(AccountStatus status) { switch(status) {
	case Offline:	return "Offline";	break;
	case Online:	return "Online";	break;
	case Away:	return "Away";		break;
	default:	return "(unknown)";	break; } }
	
	/** sets status and emits appropriate signals */
	void setStatus(const AccountStatus & status, const QString & statusMsg);
	/** gets status */
	AccountStatus status() const { return lastStatus; }
	/** gets status message */
	QString statusMsg() const { return lastStatusMsg; }
	
	bool isOnline() const { return (lastStatus > Offline); }
	
	static QStringList actions;

public slots:
	void setName(const QString & name) { handle = name;
		QObject::setName(QString("account %1").arg(name)); }
	void tryServiceAction(int which) { emit(wantsServiceAction(which, this)); }
	void tryGenericAction(int which) { emit(wantsGenericAction(which, this)); }
	void tryMoveTo(EbQtContact * contact);
	void moveTo(EbQtContact * contact);
	void makePreferred() { emit(wantsToBePreferred(this)); }
	void remove() { emit(wantsRemove(this)); }
	void tryOpenConv() { emit(wantsOpenConv(this)); }

signals:
	void statusChanged();
	void onlineChanged(bool online);
	void itemNeedsUpdate(EbQtAccount * a);
	void wantsServiceAction(int which, EbQtAccount * a);
	void wantsGenericAction(int which, EbQtAccount * a);
	void wantsToMoveTo(EbQtContact * c, EbQtAccount * a);
	void wantsToBePreferred(EbQtAccount * a);
	void wantsRemove(EbQtAccount * a);
	void wantsOpenConv(EbQtAccount * a);

private:
	QString handle;
	/** last known status */
	AccountStatus lastStatus;
	/** last known status message */
	QString lastStatusMsg;
	/** the contact this account is a buddy of */
	EbQtContact * accContact;
};

#endif
