/***************************************************************************
                          ebqtaccount.cpp  -  description
                             -------------------
    begin                : Sun Aug 4 2002
    copyright            : (C) 2002-3 by Chris Boyle
    email                : cmb@everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, when you distribute EbQt binaries under section 3 of     *
 *   the GPL, I waive the requirement for the source code of Qt to be      *
 *   available. Source for all other parts is still required.              *
 *                                                                         *
 ***************************************************************************/

#include "ebqtaccount.h"
#include "ebqtcontact.h"
#include "ebqtlocalaccount.h"
#include "ebqtservice.h"

QStringList EbQtAccount::actions;

EbQtAccount::EbQtAccount(EbQtContact * contact, EbQtLocalAccount * localAcct,
	const QString & name) :
	QObject(localAcct),
	lastStatus(Offline),
	lastStatusMsg(statusDesc(lastStatus)),
	accContact(contact)
{
	setName(name);
	if (contact)
		contact->addAccount(this);
	if (localAcct)
		localAcct->addAccount(this);
}

EbQtAccount::~EbQtAccount()
{
	if (contact())
		contact()->takeAccount(this);
	if (localAccount())  // may be dying too, but QDict should cope
		localAccount()->takeAccount(this);
}

EbQtService * EbQtAccount::service() const { return localAccount()->service(); }

void EbQtAccount::setStatus(const AccountStatus & status, const QString & statusMsg)
{
	if (status == lastStatus && statusMsg == lastStatusMsg) return;
	bool cameOn = FALSE, wentOff = FALSE;
	if (status >= Online && lastStatus <= Offline)
		cameOn = TRUE;
	else if (status <= Offline && lastStatus >= Online)
		wentOff = TRUE;
	lastStatus = status;
	lastStatusMsg = /*statusMsg.isEmpty() ? statusDesc(status) :*/ statusMsg;
	emit(itemNeedsUpdate(this));
	emit(statusChanged());
	if (cameOn)
		emit(onlineChanged(TRUE));
	else if (wentOff)
		emit(onlineChanged(FALSE));
}

void EbQtAccount::tryMoveTo(EbQtContact * contact)
{
	// this is allowed now, and used to make an account the preferred one
	//if (contact == this->contact()) return;
	emit(wantsToMoveTo(contact, this));
}

void EbQtAccount::moveTo(EbQtContact * contact)
{
	this->contact()->takeAccount(this);
	// NOT contact->insertChild() since the local acct is the parent, not the contact!
	accContact = contact;
	contact->addAccount(this, TRUE);
}

