/* File     : service.h
   Desc     : Service classes
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SERVICE_H
#define SERVICE_H

enum ServiceActionType
{
  buddy,
  groupchat,
  group_users
};

struct RgbColour
{
  unsigned char r;
  unsigned char g;
  unsigned char b;
};

class Action
{
 public:
  Action(char *name);
  ~Action();
 private:
  char *name;
};

class ActionList
{
 public:
  ActionList();
  ~ActionList();
  void add(Action *a);
 private:
  Action *first;
  ActionList *next;
};

class ServiceAction
{
 public:
  ServiceAction(char *type, char *numActions);
  ~ServiceAction();
  void addAction(Action *a);
 private:
  char *type;
  int numActions;
  ActionList *actions;
};

class ServiceActionList
{
 public:
  ServiceActionList();
  ~ServiceActionList();
  void add(ServiceAction *sa);
 private:
  ServiceAction *first;
  ServiceActionList *next;
};

class State
{
 public:
  State(char *name);
  ~State();
 private:
  char *name;
};

class StateList
{
 public:
  StateList();
  ~StateList();
  void add(State *s);
 private:
  State *first;
  StateList *next;
};

class Service
{
 public:
  Service(char *name, char *colour, char *capabilities);
  ~Service();
  char *getName() const;
  int getR() const;
  int getG() const;
  int getB() const;
  int getNearestColour() const;
  void setNumStates(int n);
  void setNumStates(char *n);
  void addServiceAction(ServiceAction *sa);
  void addState(State *s);
  RgbColour convert(char *color) const;
 private:
  char *name;
  RgbColour colour;
  int capabilities;
  ServiceActionList *serviceActions;
  int numStates;
  StateList *states;
};

class ServiceList
{
 public:
  ServiceList();
  ~ServiceList();
  int count() const;
  Service *getFirst() const;
  void setFirst(Service *s);
  void add(Service *s);
  Service *find(char *name) const;
 private:
  Service *first;
  ServiceList *next;
};

#endif
