/* File     : main.cpp
   Desc     : Main for ebnc
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "GUIcomms.h"
#include "service.h"
#include "group.h"
#include "account.h"
#include "ebncurses.h"

int main(int argc, char *argv[])
{
  char *host = "localhost";
  int port = 18234;
  unsigned char cookie[8];
  FILE *cookieFile;
  fd_set fds;
  int c;

  if (argc!=2 && argc != 3)
  {
    printf ("Usage: ebnc <cookie> [<host>]\n");
    return 1;
  }
  if (argc == 3)
    host = argv[2];

  /* Read cookie file */
  cookieFile = fopen(argv[1], "r");
  if (cookieFile == NULL)
  {
    printf("Unable to open cookie file\n");
    return 1;
  }
  port = fgetc(cookieFile)*256 + fgetc(cookieFile);
  for (c=0; c<8; c++)
    cookie[c]=(unsigned char)fgetc(cookieFile);
  fclose(cookieFile);

  /* Connection to the core */
  printf("Connecting to Everybuddy...\n");
  if (connect_gui_socket(host, port, cookie))
  {
    printf("Connection failed.\n");
    return 1;
  }
  printf("Connected, starting UI.\n");

  //getchar(); // for debug

  EbNcurses *ebnc = new EbNcurses();
  
  /* Main loop */
  while (1)
  {
    FD_ZERO(&fds);
    FD_SET(STDIN_FILENO, &fds);
    FD_SET(gui_in, &fds);
    select(gui_in+1, &fds, NULL, NULL, NULL);
    if (FD_ISSET(STDIN_FILENO, &fds))
      ebnc->getGUI()->readInput();
    if (FD_ISSET(gui_in, &fds))
    {
      int n;
      char **cmd = read_gui_message(&n);
      if (cmd!=NULL)
      {
	if (cmd[0]!=NULL)
	  ebnc->readCommand(cmd, n);
	free_gui_message(cmd);
      }
    }
  }
}
