/* File     : group.h
   Desc     : Group classes
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUP_H
#define GROUP_H

class LocalAccount;
class Contact;
class Group;

#include "service.h"
#include "account.h"

class ContactAccount
{
 public:
  ContactAccount(LocalAccount *localAccount, char *name, char *isBlocked);
  ~ContactAccount();
  LocalAccount *getLocalAccount() const;
  Service *getService() const;
  char *getName() const;
  char *getStatusString() const;
  int getStatus() const;
  bool isLogged() const;
  Contact *getContact() const;
  Group *getGroup() const;
  void updateStatus(int status, char *statusString);
  void login();
  void logout();
  void setContact(Contact *c);
 private:
  LocalAccount *localAccount;
  char *name;
  char *statusString;
  int isBlocked;
  int status;
  Contact *contact;
};

class ContactAccountList
{
 public:
  ContactAccountList();
  ~ContactAccountList();
  ContactAccount *getFirst() const;
  ContactAccountList *getNext() const;
  void add(ContactAccount *ca);
 private:
  ContactAccount *first;
  ContactAccountList *next;
};

class Contact
{
 public:
  Contact(char *name, char *isIgnored, char *ignoreMessage);
  ~Contact();
  char *getName() const;
  int getStatus() const;
  char *getStatusString() const;
  bool isLogged() const;
  ContactAccountList *getAccounts() const;
  Group *getGroup() const;
  void setName(char *name);
  void updateStatusAccount(ContactAccount* updatedAccount);
  void login();
  void logout();
  void addAccount(ContactAccount *ca);
  void setGroup(Group *g);
 private:
  char *name;
  ContactAccount* statusAccount;
  int isIgnored;
  char *ignoreMessage;
  ContactAccountList *contactAccounts;
  Group *group;
};

class ContactList
{
 public:
  ContactList();
  ~ContactList();
  Contact *getFirst() const;
  ContactList *getNext() const;
  void add(Contact *c);
  void del(char *name);
  Contact *find(char *name) const;
 private:
  Contact *first;
  ContactList *next;
};

class Group
{
 public:
  Group(char *name);
  ~Group();
  char *getName() const;
  ContactList *getContacts() const;
  void addContact(Contact *c);
  void delContact(char *name);
  Contact *findContact(char *name) const;
 private:
  char *name;
  ContactList *contacts;
};

class GroupList
{
 public:
  GroupList();
  ~GroupList();
  Group *getFirst() const;
  GroupList *getNext() const;
  void add(Group *g);
  void del(char *name);
  Group *find(char *name) const;
  void moveContact(char *name, Group *group1, Group *group2);
 private:
  Group *first;
  GroupList *next;
};

#endif
