/* File     : ebncurses.h
   Desc     : All the calls to the ncurses library are here
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EBNCURSES_H
#define EBNCURSES_H

#ifndef CTRL
#define CTRL(x)		((x) & 0x1f)
#endif

#include <string>
#include "service.h"
#include "group.h"
#include "account.h"
#include "windows.h"
using namespace std;

class EbNcurses
{
 public:
  EbNcurses();
  ~EbNcurses();
  EbncGUI *getGUI() const;
  void readCommand(char **command, int numParams) const;
 private:
  ServiceList *services;
  GroupList *groups;
  LocalAccountList *localAccounts;
  EbncGUI *gui;
};

#endif // EBNCURSES_H
