/* File     : account.h
   Desc     : Account classes
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACCOUNT_H
#define ACCOUNT_H

class ContactAccount;

#include "service.h"
#include "group.h"

class LocalContactAccountList
{
 public:
  LocalContactAccountList();
  ~LocalContactAccountList();
  ContactAccount *getFirst() const;
  LocalContactAccountList *getNext() const;
  void add(ContactAccount *ca);
  ContactAccount *find(char *name) const;
 private:
  ContactAccount *first;
  LocalContactAccountList *next;  
};

class LocalAccount
{
 public:
  LocalAccount(char *username, Service *service);
  ~LocalAccount();
  char *getUsername() const;
  Service *getService() const;
  bool isConnected() const;
  bool isReady() const;
  void update(char *connected, char *ready, char *status);
  void addContactAccount(ContactAccount *ca);
  ContactAccount *findAccount(char *name) const;
 private:
  char *username;
  Service *service;
  int connected;
  int ready;
  char *status;
  LocalContactAccountList *localContactAccounts;
};

class LocalAccountList
{
 public:
  LocalAccountList();
  ~LocalAccountList();
  LocalAccount *getFirst() const;
  LocalAccountList *getNext() const;
  void add(LocalAccount *la);
  LocalAccount *find(Service *service, char *username) const;
private:
  LocalAccount *first;
  LocalAccountList *next;
};

#endif
