/* File     : account.cpp
   Desc     : Account classes
   Authors  : Karine Proot (kproot@nerim.net)                              */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <string.h>
#include <stdlib.h>
#include "service.h"
#include "group.h"
#include "account.h"

/*** LocalContactAccountList ***/

LocalContactAccountList::LocalContactAccountList()
{
  first = NULL;
  next = NULL;
}

LocalContactAccountList::~LocalContactAccountList()
{
  if (first)
  {
    delete first;
    first = NULL;
  }
  if (next)
  {
    delete next;
    next = NULL;
  }
}

ContactAccount *LocalContactAccountList::getFirst() const
{
  return first;
}

LocalContactAccountList *LocalContactAccountList::getNext() const
{
  return next;
}

void LocalContactAccountList::add(ContactAccount *ca)
{
  if (first == NULL)
  {
    first = ca;
    next = new LocalContactAccountList();
  }
  else
    next->add(ca);
}

ContactAccount *LocalContactAccountList::find(char *name) const
{
  if (!strcmp(first->getName(), name))
    return first;
  else
  {
    if (next == NULL)
      return NULL;
    else
      return next->find(name);
  }
}

/*** LocalAccount ***/

LocalAccount::LocalAccount(char *username, Service *service)
{
  this->username = strdup(username);
  this->service = service;
  connected = 0;
  ready = 0;
  status = NULL;
  localContactAccounts = new LocalContactAccountList();
}

LocalAccount::~LocalAccount()
{
  if (username)
  {
    free(username);
    username = NULL;
  }
  if (status)
  {
    free(status);
    status = NULL;
  }
  if (localContactAccounts)
  {
    delete localContactAccounts;
    localContactAccounts = NULL;
  }
}

char *LocalAccount::getUsername() const
{
  return username;
}

Service *LocalAccount::getService() const
{
  return service;
}

bool LocalAccount::isConnected() const
{
  return (connected == 1);
}

bool LocalAccount::isReady() const
{
  return (ready == 1);
}

void LocalAccount::update(char *connected, char *ready, char *status)
{
  this->connected = strtol(connected, NULL, 10);
  this->ready = strtol(ready, NULL, 10);
  this->status = strdup(status);
}

void LocalAccount::addContactAccount(ContactAccount *ca)
{
  localContactAccounts->add(ca);
}

ContactAccount *LocalAccount::findAccount(char *name) const
{
  return localContactAccounts->find(name);
}

/*** LocalAccountList ***/

LocalAccountList::LocalAccountList()
{
  first = NULL;
  next = NULL;
}

LocalAccountList::~LocalAccountList()
{
  if (first)
  {
    delete first;
    first = NULL;
  }
  if (next)
  {
    delete next;
    next = NULL;
  }
}

LocalAccount *LocalAccountList::getFirst() const
{
  return first;
}

LocalAccountList *LocalAccountList::getNext() const
{
  return next;
}

void LocalAccountList::add(LocalAccount *la)
{
  if (first == NULL)
  {
    first = la;
    next = new LocalAccountList();
  }
  else
    next->add(la);
}

LocalAccount *LocalAccountList::find(Service *service, char *username) const
{
  if (first->getService() == service  && !strcmp(first->getUsername(), username))
    return first;
  else
    return next->find(service, username);
}
