// util.h
#ifndef __UTIL_H__
#define __UTIL_H__

#include <unistd.h>

#include "elist.h"
#include "accounts.h"
#include "contactlist.h"

#ifdef __cplusplus
extern "C" {
#endif

void eb_sign_on_all(void);
void eb_sign_off_all(void);

void eb_log_out_account(eb_local_account * account);

eb_group * eb_get_group(char * name);
eb_contact * eb_get_contact(char * group_name, char * contact_name);
eb_account * eb_get_account(char * buddy, char * service, char * handle);
eb_local_account * eb_get_local_account(char * handle, char * service);
eb_service * eb_get_service(char * name);
eb_group_chat * eb_get_group_chat(int id);

eb_account * eb_get_message_account(eb_contact * cont, char * buddy_of, char * service, char * handle, int capabilities);


eb_group * eb_add_group(char * name);
eb_contact * eb_add_contact(eb_group * group, char * name);
void eb_rename_contact(eb_contact * contact, char * newname);
void eb_move_contact(eb_contact * contact, eb_group * dest);
// ^^^ WARNING - could delete the contact object if there is already a contact of that
// name in the destination group - accounts will be merged, and the old contact deleted
eb_account * eb_add_account(eb_contact * contact, eb_local_account * buddy_of, eb_account * account);
eb_account * eb_add_account_plus(char * gname, char * cname, eb_local_account * buddy_of, char * aname);
void eb_move_account(eb_account * account, eb_contact * dest);

void eb_del_group(eb_group * group);
void eb_del_contact(eb_contact * contact);
void eb_del_account(eb_account * account);

void eb_set_away(char * title, char * body);
void eb_unset_away(void);

char * eb_escape_reg_key_name(char * name);
char * eb_unescape_reg_key_name(char * name);

char * eb_ascii2utf(unsigned char * s);
char * eb_utf2ascii(unsigned char * s);

void eb_hold_messages(int do_hold);

// Wrapper for read(), which *ensures* that data has arrived
// if it possibly can
int eread(int fd, void * data, int len);
// ditto for write()
int ewrite(int fd, void * data, int len);

char * eb_get_filename(char * subdir);

char * eb_url_encode(char * s);

#ifdef __cplusplus
}
#endif

#endif // __UTIL_H__
