#include <stdio.h>

#include "html.h"

void print_html_item(eb_html_item * item, int indent)
{
  int a;
  EList * n;
  for(a=0; a<indent; a++) { putchar(' '); }
  printf("--- Entity type: ");

  switch(item->type)
  {
    case(EB_HTML_BODY) : {
      printf("Body\n");
      break;
    }

    case(EB_HTML_TEXT) : {
      printf("Text\n");
      for(a=0; a<indent; a++) { putchar(' '); }
      printf("Content: \"%s\"\n", (char *)item->data);
      break;
    }

    case(EB_HTML_LINK) : {
      eb_link_data * data=(eb_link_data *)item->data;

      printf("Link (anchor)\n");
      for(a=0; a<indent; a++) { putchar(' '); }

      if(data->target!=NULL)
      {
        printf("Target: \"%s\"\n", data->target);
      } else {
        printf("No target\n");
      }
      break;
    }

    case(EB_HTML_ENCODED) : {
      eb_encoded_data * data=(eb_encoded_data *)item->data;
      printf("Encoded %c  (%s)\n", data->real, data->encoded);
      break;
    }

    default : {
      printf("Unknown (%d)\n", item->type);
    }
  }

  putchar('\n');

  if(item->contents!=NULL)
  {
    for(a=0; a<indent; a++) { putchar(' '); }
    printf("Children:\n");

    for(n=item->contents; n!=NULL; n=n->next)
    {
      print_html_item((eb_html_item *)n->data, indent+4);
    }
  }
}

int main()
{
  eb_html_item * body;
  char buf[1024];

  printf("Enter HTML: ");
  fgets(buf, 1024, stdin);
  if(buf[strlen(buf)-1]=='\n') { buf[strlen(buf)-1]='\0'; }

  printf("Parsing...%02x%02x\n", 5, 19);

  body=eb_html_parse(buf);

  print_html_item(body, 0);

  printf("Reconstructed HTML:\t%s\nStripped text:\t\t%s\n", eb_html_render(body), eb_html_render_plain(body)); }
