// stringmap.c (GPL, see main files)

#include <stdlib.h>

#include "stringmap.h"


void eb_string_map_put(eb_string_map * map, char * name, void * value)
{
  EList * n;
  eb_string_map_entry * entry;
  for(n=(*map); n!=NULL; n=n->next)
  {
    entry=(eb_string_map_entry *)n->data;
    if(!strcmp(entry->name, name))
    { entry->value=value; return; }
  }
  
  entry=(eb_string_map_entry *)malloc(sizeof(eb_string_map_entry));
  entry->name=strdup(name);
  entry->value=value;
  (*map)=e_list_append(*map, entry);
}

void * eb_string_map_get(eb_string_map map, char * name)
{
  EList * n;
  
  for(n=map; n!=NULL; n=n->next)
  {
    eb_string_map_entry * entry=(eb_string_map_entry *)n->data;
    if(!strcmp(entry->name, name))
    { return entry->value; }
  }
  
  return NULL;
}

void eb_string_map_remove_name(eb_string_map * map, char * name)
{
  EList * n;
  
  for(n=(*map); n!=NULL; n=n->next)
  {
    eb_string_map_entry * entry=(eb_string_map_entry *)n->data;
    if(!strcmp(entry->name, name))
    {
      e_list_remove_link(*map, n);
      e_list_free_1(n);
      free(entry->name);
      return;
    }
  }
}

void eb_string_map_remove_value(eb_string_map * map, void * value)
{
  EList * n;
  
  for(n=(*map); n!=NULL; n=n->next)
  {
    eb_string_map_entry * entry=(eb_string_map_entry *)n->data;
    if(entry->value==value)
    {
      e_list_remove_link(*map, n);
      e_list_free_1(n);
      free(entry->name);
      return;
    }
  }
}

