// stream.h - Everybuddy generic streaming implementation

#ifndef __STREAM_H__
#define __STREAM_H__

#include "gui_comms.h"

#define EB_STREAM_IN  0
#define EB_STREAM_OUT 1

#define EB_STREAM_SUCCESS	0
#define EB_STREAM_DATA		1	// New data (buffer streams only)
#define EB_STREAM_ABORT		-1	// Aborted
#define EB_STREAM_IO		-2	// I/O error

extern char * eb_stream_errors[];

typedef struct _eb_stream
{
  int id;
  int fd; // local file descriptor, or -1 for buffer
  int direction;
  eb_gui * gui;
  
  char * buffer;
  int buflen;
  int terminate_on_empty; // only valid for outbound streams

  int rd_tag;
  int wr_tag;
  int wready;

  void (*cb)(int error, void * data);
  void * cb_data;
} eb_stream;

extern int eb_stream_next;

#ifdef __cplusplus
extern "C" {
#endif

#define eb_stream_next_id() (eb_stream_next++)

eb_stream * eb_stream_file(eb_gui * gui, char * filename, int direction, void (*cb)(int error, void * data), void * cb_data, int id);
eb_stream * eb_stream_fd(eb_gui * gui, int fd, int direction, void (*cb)(int error, void * data), void * cb_data, int id);

eb_stream * eb_stream_buffer(eb_gui * gui, char * buffer, int len, int direction, void (*cb)(int error, void * data), void * cb_data, int id);

void eb_stream_abort(eb_stream * stream);

void eb_stream_incoming(eb_stream * stream, void * data, int len);
void eb_stream_finished(eb_stream * stream);


eb_stream * eb_stream_get(eb_gui * gui, int id, int direction);

#ifdef __cplusplus
}
#endif

#endif // __STREAM_H__
