#ifndef _SMILEYS_
#define _SMILEYS_

#include "elist.h"


struct protocol_smiley_struct
{
  char text[16]; // :-), :), ;-), etc
  char name[64]; // this goes into the <smiley> tag for the gtkhtml stuff
};

typedef struct protocol_smiley_struct protocol_smiley;


struct smiley_struct
{
  char name[64];
  char ** pixmap; // from an xpm file, you know the drill...
};

typedef struct smiley_struct smiley;

extern EList *smileys;

#ifdef __cplusplus
extern "C" {
#endif

void init_smileys(void);
char * eb_smilify(char * text, EList * protocol_smileys);

EList * eb_default_smileys(void);

EList * add_smiley(EList * list, char * name, char ** data);

EList * add_protocol_smiley(EList * list, char * text, char * name);

/* someone figure out how to do this with GList * const */
EList * eb_smileys(void);

smiley * get_smiley_by_name(char * name);
extern int do_smiley;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // ifndef _SMILEYS_
