// registry.h - EB registry management code
#ifndef __REGISTRY_H__
#define __REGISTRY_H__

#include "elist.h"

typedef struct _eb_registry_key {
  char * name;
  EList * subkeys;
  EList * values;
} eb_registry_key;

typedef struct _eb_registry_value {
  char * name;
  char * value;
} eb_registry_value;

#ifdef __cplusplus
extern "C" {
#endif

char * eb_get_value(eb_registry_key * key, char * path); // DON'T free this
// '/' is the designated separator for neatness' sake
eb_registry_key * eb_get_key(eb_registry_key * key, char * path);
void eb_del_value(eb_registry_key * key, char * name);
void eb_del_key(eb_registry_key * skey, eb_registry_key * target);

void eb_put_value(eb_registry_key * key, char * name, char * value); // this is strdup()ed
void eb_put_default(eb_registry_key * key, char * name, char * value);

void eb_load_key(eb_registry_key * key, char * fnam);
void eb_save_key(eb_registry_key * key, char * fnam);

#if defined(__MINGW32__) && defined(__IN_PLUGIN__)
__declspec(dllimport) eb_registry_key * registry;
#else
extern eb_registry_key * registry;
#endif

#ifdef __cplusplus
}
#endif

#endif // __REGISTRY_H__
