/***************************************************************************
                  regbrowser.c - Everybuddy registry editor
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "elist.h"

#include "registry.h"

char curpath[1024]="/";
char buf[1024];

eb_registry_key reg={"ROOT", NULL, NULL};

eb_registry_key * current_key=&reg;

int main(int argc, char ** argv)
{
  int saved=1;

  if(argc==2)
  {
    printf("Loading registry from %s\n", argv[1]);
    eb_load_key(&reg, argv[1]);
  }

  while(1)
  {
    printf("%s> ", curpath);
    fflush(stdout);
    scanf(" %s", buf);
    if(!strcmp(buf, "lvals") || !strcmp(buf, "list"))
    {
      EList * n;
      int total=0;

      printf("Values:\n");

      for(n=current_key->values; n!=NULL; n=n->next)
      {
        eb_registry_value * thisval=(eb_registry_value *)n->data;

        printf("%s:\t\t\"%s\"\n", thisval->name, thisval->value);
        total++;
      }

      printf("Total: %d values\n", total);

      if(strcmp(buf, "list")) { continue; }
    }

    if(!strcmp(buf, "getval"))
    {
      scanf(" %s", buf);
      printf("%s:\t\t\"%s\"\n", buf, eb_get_value(current_key, buf));

      continue;
    }

    if(!strcmp(buf, "ck"))
    {
      scanf(" %s", buf);

      if(buf[0]=='/')
      {
        strcpy(curpath, buf);
        if(buf[1]=='\0') { current_key=&reg; continue; }
        current_key=eb_get_key(&reg, buf+1);
      } else {
        current_key=eb_get_key(current_key, buf);
        if(curpath[1]!='\0') { strcat(curpath, "/"); } // don't duplicate initial /
        strcat(curpath, buf);
      }

      continue;
    }

    if(!strcmp(buf, "rmk"))
    {
      EList * n;
      scanf(" %s", buf);

      for(n=current_key->subkeys; n!=NULL; n=n->next)
      {
        eb_registry_key * key=(eb_registry_key *)n->data;

        if(!strcmp(key->name, buf))
        {
          current_key->subkeys=e_list_remove_link(current_key->subkeys, n);
          // KLUDGE ALERT! This leaks the entire key and all subkeys
          // It was implemented in a hurry, when I needed desperately
          // to salvage my registry, having screwed it sideways with a bad
          // development build...
          break;
        }
      }

      continue;
    }

    if(!strcmp(buf, "lkeys") || !strcmp(buf, "list"))
    {
      EList * n;
      int total=0;

      printf("Keys:\n");

      for(n=current_key->subkeys; n!=NULL; n=n->next)
      {
        eb_registry_key * thiskey=(eb_registry_key *)n->data;

        printf("%s\n", thiskey->name);
        total++;
      }
      printf("Total: %d keys\n", total);
      continue;
    }

    if(!strcmp(buf, "putval"))
    {
      char buf2[1024];

      while(getc(stdin)!='\n');

      printf("Name: ");
      fflush(stdout);
      fgets(buf, 1024, stdin);
      buf[strlen(buf)-1]='\0';

      printf("Value: ");
      fflush(stdout);
      fgets(buf2, 1024, stdin);
      buf2[strlen(buf2)-1]='\0';

      eb_put_value(current_key, buf, buf2);

      printf("Key updated\n");
      saved=0;
      continue;
    }

    if(!strcmp(buf, "save"))
    {
      scanf(" %s", buf);
      eb_save_key(&reg, buf);

      printf("Registry saved\n");
      saved=1;
      continue;
    }

    if(!strcmp(buf, "quit"))
    {
      if(!saved)
      {
        char c;

        printf("Unsaved changes - quit (y/n)? ");
        fflush(stdout);

        scanf(" %c", &c);

        if(c=='y') { exit(0); }

        while(fgetc(stdin)!='\n');
        continue;
      }
      exit(0);
    }

    printf("Unknown command: \"%s\"\n", buf);

    while(getc(stdin)!='\n');
  }
}
