// prefs.h - preferences
#ifndef __PREFS_H__
#define __PREFS_H__

#include "elist.h"
#include "registry.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _eb_pref_page {
  char * name;
  char * title;

  struct _eb_pref_page * parent; // yuck, can't use the typedef yet...

  EList * subpages;
  EList * components;
} eb_pref_page;

typedef enum {
  EB_PREF_LABEL=0,
  EB_PREF_STRING=1,
  EB_PREF_PASSWORD=2,
  EB_PREF_TOGGLE=3,
  EB_PREF_OPTION=4,
  EB_PREF_BUTTON=5
} EB_PREF_TYPE;

typedef struct _eb_pref {
  EB_PREF_TYPE type;
  eb_pref_page * parent;
  char * name;
  char * title;
  eb_registry_key * target;
  char * valuename;
  void * data;

  void (*callback)(struct _eb_pref * pref, void * tag); // called on change
  void * callback_tag;
} eb_pref;

typedef struct _eb_option_data {
  EList * options;
} eb_option_data;

#if defined(__MINGW32__) && defined(__IN_PLUGIN__)
__declspec(dllimport) char * eb_pref_type_names[];
__declspec(dllimport) EList * prefs; // holds ALL pages in no heirarchical order
__declspec(dllimport) eb_pref_page * mainprefs; // root prefs page
__declspec(dllimport) eb_pref_page * account_prefs; // contains prefs for each account
__declspec(dllimport) eb_pref_page * features; // Miscellaneous whizz-bang plugins
#else
extern char * eb_pref_type_names[];
extern EList * prefs; // holds ALL pages in no heirarchical order
extern eb_pref_page * mainprefs; // root prefs page
extern eb_pref_page * account_prefs; // contains prefs for each account
extern eb_pref_page * features; // Miscellaneous whizz-bang plugins
#endif


void prefs_init(void);

eb_pref_page * eb_make_pref_page(eb_pref_page * parent, char * name, char * title);
eb_pref_page * eb_get_pref_page(char * name);
void eb_destroy_pref_page(eb_pref_page * page);

eb_pref * eb_add_component(eb_pref_page * parent, EB_PREF_TYPE type, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag);
eb_pref * eb_add_option_strings(eb_pref_page * parent, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag, char * options[], int numopts);
eb_pref * eb_add_option_elist(eb_pref_page * parent, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag, EList * options);
eb_pref * eb_get_component(eb_pref_page * parent, char * name);
void eb_destroy_component(eb_pref * pref);

#ifdef __cplusplus
}
#endif

#endif //__PREFS_H__
