/***************************************************************************
                            prefs.c - Preferences
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "elist.h"
#include "prefs.h"

char * eb_pref_type_names[]={"label", "string", "password", "toggle", "option", "button"};
EList * prefs;
eb_pref_page * mainprefs;
eb_pref_page * features;
eb_pref_page * account_prefs;

void prefs_init(void)
{
  eb_pref_page * general;
//  eb_pref_page * group;
  eb_pref_page * page;

  char * proxopts[]={"Direct connection", "SOCKS 5", "HTTP Proxy"};

  mainprefs=eb_make_pref_page(NULL, "mainprefs", "Everybuddy preferences");
  account_prefs=eb_make_pref_page(NULL, "accounts", "Account Editor");

  features=eb_make_pref_page(mainprefs, "features", "Features");

  general=eb_make_pref_page(mainprefs, "general", "General");
  eb_add_component(general, EB_PREF_STRING, "plugin_dir", "Plugin directory (requires restart):", registry, "config/plugin_dir", NULL, NULL);

  /*
  group=eb_make_pref_page(mainprefs, "groupchat", "Group Chat");
   
  eb_add_component(group, EB_PREF_TOGGLE, "hilite", "Highlight your nickname in group chat", registry, "config/groupchat/hilight", NULL, NULL);
  */
  
  /*page=eb_make_pref_page(mainprefs, "playpen", "Playpen");
  eb_add_component(page, EB_PREF_LABEL, "lbl", "This is a sample page for widget tests", registry, "params/dump", NULL, NULL);
  eb_add_option_strings(page, "opts", "Test option box", registry, "params/dump", NULL, NULL, playopts, 5);
  */
  
  page=eb_make_pref_page(mainprefs, "chat_logs", "Chat logs");
  eb_add_component(page, EB_PREF_LABEL, "lbl", "Warning: The chat log code is incomplete and experimental.", registry, "params/dump", NULL, NULL);
  eb_add_component(page, EB_PREF_LABEL, "lbl2", "It leaves logs in a format for which there is currently no reader, and may affect performance.", registry, "params/dump", NULL, NULL);
  eb_add_component(page, EB_PREF_TOGGLE, "tryit", "Try it anyway", registry, "config/log_conversations", NULL, NULL);
  
  page=eb_make_pref_page(mainprefs, "proxy", "Proxy Server");
  eb_add_option_strings(page, "proxtype", "Proxy type", registry, "config/proxy/type", NULL, NULL, proxopts, 3);

  general=page;
  page=eb_make_pref_page(general, "socks5_proxy", "SOCKS 5");
  eb_add_component(page, EB_PREF_LABEL, "lbl", "These settings only matter if you chose to use a SOCKS 5 proxy", registry, "params/dump", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "host", "Server hostname:", registry, "config/proxy/socks5/host", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "port", "Port:", registry, "config/proxy/socks5/port", NULL, NULL);
  
  page=eb_make_pref_page(general, "http_proxy", "HTTP Proxy");
  eb_add_component(page, EB_PREF_LABEL, "lbl", "These settings only matter if you chose to use an HTTP proxy", registry, "params/dump", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "host", "Proxy host:", registry, "config/proxy/http/host", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "port", "Proxy port:", registry, "config/proxy/http/port", NULL, NULL);
  eb_add_component(page, EB_PREF_TOGGLE, "doauth", "Proxy needs a username and password", registry, "config/proxy/http/doauth", NULL, NULL);
  eb_add_component(page, EB_PREF_STRING, "user", "Username:", registry, "config/proxy/http/username", NULL, NULL);
  eb_add_component(page, EB_PREF_PASSWORD, "pass", "Password:", registry, "config/proxy/http/password", NULL, NULL);
}

eb_pref_page * eb_make_pref_page(eb_pref_page * parent, char * name, char * title)
{
  eb_pref_page * page=(eb_pref_page *)malloc(sizeof(eb_pref_page));

  page->name=strdup(name);
  page->title=strdup(title);
  page->parent=parent;
  if(parent!=NULL)
  {
    parent->subpages=e_list_append(parent->subpages, page);
  }
  page->subpages=NULL;
  page->components=NULL;

  prefs=e_list_append(prefs, page);

  return page;
}

eb_pref_page * eb_get_pref_page(char * name)
{
  EList * n;

  for(n=prefs; n!=NULL; n=n->next)
  {
    eb_pref_page * page=(eb_pref_page *)n->data;

    if(!strcmp(page->name, name)) { return page; }
  }

  return NULL;
}

void eb_destroy_pref_page(eb_pref_page * page)
{
  EList * n;
  EList * tmp=NULL;

  if(page->parent!=NULL)
  {
    page->parent->subpages=e_list_remove(page->parent->subpages, page);
  }

  prefs=e_list_remove(prefs, page);

  free(page->name);
  free(page->title);

  tmp=e_list_copy(page->subpages);
  for(n=tmp; n!=NULL; n=n->next)
  {
    eb_pref_page * spage=(eb_pref_page *)n->data;

    eb_destroy_pref_page(spage);
  }
  e_list_free(tmp);

  tmp=e_list_copy(page->components);
  for(n=tmp; n!=NULL; n=n->next)
  {
    eb_pref * pref=(eb_pref *)n->data;

    eb_destroy_component(pref);
  }
  e_list_free(tmp);

  free(page);
}

eb_pref * eb_add_component(eb_pref_page * parent, EB_PREF_TYPE type, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag)
{
  eb_pref * pref=(eb_pref *)malloc(sizeof(eb_pref));

  pref->parent=parent;
  pref->type=type;
  pref->name=strdup(name);
  pref->title=strdup(title);
  pref->target=target;
  pref->valuename=strdup(valuename);
  pref->callback=callback;
  pref->callback_tag=tag;
  pref->data=NULL;

  parent->components=e_list_append(parent->components, pref);

  return pref;
}

eb_pref * eb_add_option_elist(eb_pref_page * parent, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag, EList * options)
{
  eb_pref * pref=eb_add_component(parent, EB_PREF_OPTION, name, title, target, valuename, callback, tag);
  eb_option_data * eod=(eb_option_data *)malloc(sizeof(eb_option_data));

  pref->data=eod;
  eod->options=options;

  return pref;
}

eb_pref * eb_add_option_strings(eb_pref_page * parent, char * name, char * title, eb_registry_key * target, char * valuename, void (*callback)(eb_pref * pref, void * tag), void * tag, char * options[], int numopts)
{
  eb_pref * pref=eb_add_component(parent, EB_PREF_OPTION, name, title, target, valuename, callback, tag);
  eb_option_data * eod=(eb_option_data *)malloc(sizeof(eb_option_data));
  int a=0;

  pref->data=eod;
  eod->options=NULL;

  for(a=0; a<numopts; a++)
  {
    eod->options=e_list_append(eod->options, options[a]);
  }

  return pref;
}

eb_pref * eb_get_component(eb_pref_page * parent, char * name)
{
  EList * n;

  for(n=parent->components; n!=NULL; n=n->next)
  {
    eb_pref * pref=(eb_pref *)n->data;

    if(!strcmp(pref->name, name)) { return pref; }
  }

  return NULL;
}

void eb_destroy_component(eb_pref * pref)
{
  pref->parent->components=e_list_remove(pref->parent->components, pref);

  free(pref->name);
  free(pref->title);
  free(pref->valuename);

  if(pref->type==EB_PREF_OPTION)
  {
    eb_option_data * eod=(eb_option_data *)pref->data;
    e_list_free(eod->options);
    free(eod);
  }

  free(pref);
}
