// plugin_api.h - stub, with chunks heartlessly ripped from the "real" EB's
// plugin_api.h

#ifndef __PLUGIN_API_H__
#define __PLUGIN_API_H__

#if HAVE_CONFIG_H
# include <config.h>
# if TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
# else
#  if HAVE_SYS_TIME_H
#   include <sys/time.h>
#  else
#   include <time.h>
#  endif
# endif
#else
# include <sys/time.h>
# include <time.h>
#endif

#include "registry.h"
#include "services.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Plugin */

typedef int (*eb_plugin_func)();

typedef struct {
	char *brief_desc;
	char *full_desc;
	char *version;
	char *date;
	eb_plugin_func init;
	eb_plugin_func finish;
} eb_plugin_info;


int eb_load_service(eb_service * service); // defined in plugin.c


#define EB_INPUT_READ      0x1
#define EB_INPUT_WRITE     0x2
#define EB_INPUT_EXCEPTION 0x4

typedef int eb_input_condition; // compatibility
typedef void (*eb_input_function) (void * data, int source, int conditions);

int eb_input_add(int fd, int conditions, eb_input_function callback, void * data);
void eb_input_remove(int tag); // *this* tag was eb_input_add()'s return value

typedef int (*eb_timer_function) (void * data);
void eb_set_timer(eb_timer_function func, time_t wait, void * data);

extern char * eb_config_dir;

void eb_polling_loop();

// defined in proxy.c
int eb_connect_socket(char * hostname, int port, void (*callback)(int fd, void * data), void * data);
int eb_connect_sync_socket(char * hostname, int port); // defined in proxy.c, synchronous

#define EB_HTTP_GET     0
#define EB_HTTP_POST    1
#define EB_HTTP_CONNECT 2

int eb_http_request(char * host, int port, char * url, int method, EList * headers, void (*cb)(int s, int code, EList * headers, void * data), void * data);

void eb_http_done(int sock);
// ^^^ signal you're done with a socket, and that it can be re-used (if it's a proxy connection)
// If it's not in such a state (eg a Connection: close header, an HTTP CONNECT proxy
// request), *don't* call this function! Just close() the socket and go merrily on your way.

#ifdef __cplusplus
}
#endif

#endif
