/***************************************************************************
                plugin_api.c - Utility functions for plugins
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "elist.h"
#ifdef __MINGW32__
#include <winsock2.h>
#endif

#include "plugin_api.h"

char * eb_config_dir=NULL;

typedef struct _eb_input_callback {
  int fd;
  int conditions;
  eb_input_function callback;
  void * callback_tag;
  int remove_tag;
} eb_input_callback;

typedef struct _eb_timer_callback {
  eb_timer_function callback;
  void * callback_tag;
  time_t next_call;
  time_t increment;
} eb_timer_callback;

EList * input_callbacks=NULL;
EList * timer_callbacks=NULL;

fd_set inp;
fd_set out;
fd_set excp;

int next_remove_tag=0;
int list_mangled;

void eb_polling_loop()
{
  int did_something=0;
  EList * n;
  static int nest=0;

  // Right, the below may *look* wasteful, but I'd have to step through
  // the entire list of eb_input_callbacks anyway, so I might as well
  // simplify things and make one select() call for each one

  if(nest==0) { list_mangled=0; }
  nest++;

  for(n=input_callbacks; n!=NULL; n=n->next)
  {
    int conditions=0;
    struct timeval timeout={0, 0};
    eb_input_callback * eic=(eb_input_callback *)n->data;

#ifndef __MINGW32__
    FD_ZERO(&inp);
    FD_ZERO(&out);
    FD_ZERO(&excp);
#endif

    if(eic->conditions&EB_INPUT_READ) { FD_SET(eic->fd, &inp); }
    if(eic->conditions&EB_INPUT_WRITE) { FD_SET(eic->fd, &out); }
    if(eic->conditions&EB_INPUT_EXCEPTION) { FD_SET(eic->fd, &excp); }

    select(eic->fd+1, &inp, &out, &excp, &timeout);

    if(FD_ISSET(eic->fd, &inp)) { conditions|=EB_INPUT_READ; }
    if(FD_ISSET(eic->fd, &out)) { conditions|=EB_INPUT_WRITE; }
    if(FD_ISSET(eic->fd, &excp)) { conditions|=EB_INPUT_EXCEPTION; }


    //printf("Checking input callback for socket %d: %d\n", eic->fd, eic->conditions&EB_INPUT_READ);


    if(conditions)
    {
      eic->callback(eic->callback_tag, eic->fd, conditions);
      if(list_mangled) { break; }
      did_something=1;
    }
  }

  for(n=timer_callbacks; n!=NULL; n=n->next)
  {
    time_t now=time(NULL);
    eb_timer_callback * etc=(eb_timer_callback *)n->data;

    if(etc->next_call<=now)
    {
      int incr=etc->callback(etc->callback_tag);
      if(incr!=0)
      {
        etc->next_call=now+incr;
      } else {
        timer_callbacks=e_list_remove_link(timer_callbacks, n);
        e_list_free_1(n);
        free(etc);
      }
    }
  }

  // If nothing big is happening, then let's sleep.
  // The use of did_something is because sleeping every time would not be
  // at all good for algorithms which deliberately do not read some of the
  // available data (eg MSN filetrans, which grabs things in very small chunks)

  if(!did_something)
  {
    struct timeval sleeplen={0, 50};
    select(0, NULL, NULL, NULL, &sleeplen); // portable sleep
  }

  nest--;
}

int eb_input_add(int fd, int conditions, eb_input_function callback, void * tag)
{
  eb_input_callback * newcb=(eb_input_callback *)malloc(sizeof(eb_input_callback));

  list_mangled=1;

  newcb->fd=fd;
  newcb->conditions=conditions;
  newcb->callback=callback;
  newcb->callback_tag=tag;
  newcb->remove_tag=next_remove_tag++;

  input_callbacks=e_list_append(input_callbacks, newcb);

  return newcb->remove_tag;
}

void eb_input_remove(int tag)
{
  EList * n;
  list_mangled=1;

  for(n=input_callbacks; n!=NULL; n=n->next)
  {
    eb_input_callback * eic=(eb_input_callback *)n->data;

    if(eic->remove_tag==tag)
    {
      input_callbacks=e_list_remove_link(input_callbacks, n);
      n->data=NULL;
      //e_list_free_1(n);
      free(eic);
      return;
    }
  }
}

void eb_set_timer(eb_timer_function callback, time_t wait, void * tag)
{
  eb_timer_callback * etc=(eb_timer_callback *)malloc(sizeof(eb_timer_callback));

  etc->callback=callback;
  etc->callback_tag=tag;

  etc->next_call=time(NULL)+wait;
  etc->increment=wait;

  timer_callbacks=e_list_append(timer_callbacks, etc);
}
