// plugin.h
#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include "elist.h"

#include "plugin_api.h"
#include "services.h"

typedef enum {

  PLUGIN_NOT_LOADED=0,
  PLUGIN_LOADED=1,
  PLUGIN_CANNOT_LOAD=2

} PLUGIN_STATUS;

typedef struct _eb_plugin {
  eb_plugin_info * info;
  PLUGIN_STATUS status;

  char * filename; // full path
  char * errormsg;
} eb_plugin;


#ifdef __cplusplus
extern "C" {
#endif

void plugins_init();

void load_plugins(char * dir);

void load_static_mods(void); // defined in staticmods.c for ease's sake

extern EList * plugins; // of type eb_plugin

#ifdef __cplusplus
}
#endif

#endif // __PLUGIN_H__
