/***************************************************************************
                    misc_cb.c - Miscellaneous callbacks
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdio.h>
#include <stdlib.h>

#include "registry.h"
#include "services.h"
#include "contactlist.h"
#include "plugin_api.h"
#include "util.h"
#include "globals.h"
#include "actions.h"
#include "dialog.h"

static char ** away_ru=NULL;
static int awaydlg=0;

static void awayd_cb(char * response, void * data)
{
  awaydlg=0;
  eb_set_away(response, "");
}

static void reuse_away(void * data)
{
  eb_registry_key * key=eb_get_key(registry, "config/away_msgs");
  EList * n;
  int a;
  
  if(awaydlg) { return; }
  awaydlg=1;
  
  if(away_ru!=NULL)
  {
    for(a=0; away_ru[a]!=NULL; a++)
    { free(away_ru[a]); }
    free(away_ru);
    away_ru=NULL;
  }

  if(key->subkeys==NULL) { return; }
    
  away_ru=(char **)malloc((1+e_list_length(key->subkeys))*sizeof(char *));
    
  a=0;
  for(n=key->subkeys; n!=NULL; n=n->next)
  {
    eb_registry_key * k=(eb_registry_key *)n->data;
    
    away_ru[a]=eb_unescape_reg_key_name(k->name);
    a++;
  }
  away_ru[a]=NULL;
  
  eb_show_list_dialog("Select the away message to use", "Set Away", away_ru, awayd_cb, NULL);
}

void eb_register_misc_cb(void)
{
  eb_general_actions=e_list_append(eb_general_actions, eb_create_action("Re-use away message", reuse_away));
}

void eb_phonehome_request_cb(int s, int code, EList * headers, void * data)
{
  printf("Phone home successful - code %d\n", code);
}

void eb_phonehome_cb(int response, void * tag)
{

  char * newversion=(char *)tag;
  char * enc_oldversion;
  char * enc_newversion;
  char * url;
  
  if(!response)
  {
    printf("OK, not bothering you again\n");
    eb_put_value(registry, "config/version", newversion);
    return;
  }
  
  enc_oldversion=eb_url_encode(eb_get_value(registry, "config/version"));
  enc_newversion=eb_url_encode(newversion);
  url=(char *)malloc(strlen(enc_oldversion)+strlen(enc_newversion)+128);
  
  sprintf(url, "/eb-lite/tracking/install.php?newversion=%s&oldversion=%s", enc_newversion, enc_oldversion);
  
  eb_put_value(registry, "config/version", newversion);
  
  printf("Making HTTP request to www.everybuddy.com%s\n", url);
  eb_http_request("www.everybuddy.com", 80, url, EB_HTTP_GET, NULL, eb_phonehome_request_cb, NULL);

  free(newversion);
  free(enc_oldversion);
  free(enc_newversion);
  free(url);
}
