#ifndef __MESSAGE_PARSE_H__
#define __MESSAGE_PARSE_H__

#include <time.h>

#include "contactlist.h"
#include "html.h"

#ifdef __cplusplus
extern "C" {
#endif

#define EB_MSG_SEND        0
#define EB_MSG_RECV        1
#define EB_MSG_3RDPERSON   2
#define EB_MSG_INLINE_SEND 3
#define EB_MSG_INLINE_RECV 4

typedef struct _eb_held_message {
  eb_account * buddy;
  eb_contact * contact;
  eb_html_item * message;
  time_t when;
  int direction;
  
  char * contenttype;
  char * filename;
} eb_held_message;

extern EList * eb_held_messages;

extern EList * eb_open_logs; // points to eb_contacts

extern int eb_holding_messages;

typedef char * (*eb_filter_func) (char * string, void * context);
// the void * can be an eb_account (in one-to-one chat), or
// an eb_group_chat (in groupchat send), or an eb_group_chat_user
// (in groupchat receive). Cast it right, my friend...

typedef struct _eb_filter {
  eb_filter_func func;
  int priority; // UNIX-style: -20 to 20, low means called first. 0 is a sensible default
} eb_filter;

// filter chains

#define EB_FILTER_IN		0
#define EB_POSTNOTIFY_IN	1
#define EB_PREFILTER_OUT	2
#define EB_POSTFILTER_OUT	3
#define EB_POSTNOTIFY_OUT	4

#define EB_GROUP_FILTER_IN	5
#define EB_GROUP_POSTNOTIFY_IN	6  // very unusual - only used to kill away messages
#define EB_GROUP_PREFILTER_OUT	7
#define EB_GROUP_POSTFILTER_OUT	8
#define EB_GROUP_POSTNOTIFY_OUT	9

extern EList * eb_filters[];


// Incoming IM - this will appear in the normal fashion, with the relevant user/contact's
// name. If this is called on an ignored contact, a bounce message may be sent
void eb_incoming_message(eb_account * remote, char * message);

// 3rd person commentary to appear in the chat window with no other frills (apart from maybe
// a timestamp, at the UI's discretion). If this is called on an ignored contact,
// it will be silently dropped with no bounce
void eb_notify_3rdperson(eb_contact * contact, char * message);

// We have sent an IM successfully. Broadcast it, hold it, log it, do whatever to it.
void eb_sent_message(eb_account * remote, char * message);


// Data message received and saved. Release control of the file referred to by 
// filename; it will be deleted when the core is finished with it. An empty
// content-type or disposition means, essentially, "haven't a clue", which means
// save-to-disk. Suggested filename is ignored if the disposition is understood.
void eb_incoming_data_message(eb_account * remote, char * filename, char * contenttype, char * disposition, char * suggested_filename, int length);

// We only bother sending confirmations of sent inline messages
void eb_sent_inline_data_message(eb_account * remote, char * filename, char * contenttype);


// Utility functions to parse message-encapsulated data out of a string

typedef struct _eb_inlined_data_state {
  char * buf[5];
  int lengths[5];
} eb_inlined_data_state;

void eb_destroy_inlined_data_state(eb_inlined_data_state * ids);

int eb_handle_inlined_data(eb_account * acc, char * msg, int msglen, eb_inlined_data_state ** dsp);

void eb_package_inlined_data(char * filename, char * contenttype, int length, int max_msg_len, char * buf[], int * num_msgs);


// Filter chains

// call a filter chain on a string - this string may be free()ed by those functions
char * eb_filter_string(int chain_id, char * string, void * context);

// Add a filter to chain
void eb_add_filter(int chain_id, eb_filter_func func, int priority);

// Remove a filter from a chain
void eb_del_filter(int chain_id, eb_filter_func func);

#ifdef __cplusplus
}
#endif

#endif // __MESSAGE_PARSE_H__
