/***************************************************************************
                      message_parse.c - Filter messages
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <util.h>
#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>

#ifdef __MINGW32__
#include <winsock2.h>
#define uint16_t unsigned short
#define uint32_t unsigned int
#else
#include <netinet/in.h>
#endif

#include "globals.h"
#include "gui_comms.h"
#include "message_parse.h"

#define NOTIFY_HELD() { char * ncmd[]={"holding_message"}; if(!eb_held_messages) eb_gui_broadcast(ncmd, 1); }

// held messages
EList * eb_held_messages=NULL;
int eb_holding_messages=1;

// chat logs
EList * eb_open_logs_c=NULL;
EList * eb_open_logs_g=NULL;

static int cleanup_timer_set=0;

// filter chains
EList * eb_filters[10]={NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};

char * eb_prepare_away_msg(void);

static void eb_write_log_string(int fd, char * s)
{
  uint16_t len, belen;
  len=strlen(s); belen=htons(len);
  ewrite(fd, &belen, 2);
  ewrite(fd, s, len);
}

static void eb_write_long_log_string(int fd, char * s)
{
  uint32_t len, belen;
  len=strlen(s); belen=htonl(len);
  ewrite(fd, &belen, 4);
  ewrite(fd, s, len);
}

static int chat_log_checker(void * data)
{
  EList * n;
  time_t now=time(NULL);
  int needed=0;
  
  EList * tbr=NULL;
  
  for(n=eb_open_logs_c; n!=NULL; n=n->next)
  {
    eb_contact * c=(eb_contact *)n->data;
    
    if(c->logfile>0)
    {
      if(c->last_message+15*60<now)
      {
        close(c->logfile);
        c->logfile=0;
	tbr=e_list_append(tbr, n);
	printf("Closing %s's logile\n", c->name);
      } else {
        needed=1;
      }
    }
  }

  for(n=tbr; n!=NULL; n=n->next)
  {
    EList * victim=(EList *)n->data;
    eb_open_logs_c=e_list_remove_link(eb_open_logs_c, victim);
    e_list_free_1(victim);
  }
  
  e_list_free(tbr);

  if(needed==0) { cleanup_timer_set=0; printf("Cleanup timer going to sleep\n"); }
  return (needed==0)?(0):(5*60);
}

void eb_open_contact_logfile(eb_contact * c)
{
  int fd[2];
  char * log_name;
  char * index_name;
  char * buf;
  unsigned short a;
  uint32_t now=time(NULL), benow=htonl(now);

  if(c->logfile>0) { return; }

  printf("Opening logfile for %s\n", c->name);
    
  log_name=eb_get_filename("logs");
  if(log_name==NULL) { return; }
  
  buf=(char *)malloc(strlen(eb_config_dir)+16);
  
  c->logfile=open(log_name, O_WRONLY|O_CREAT|O_APPEND|O_SYNC, 00600);
  if(c->logfile==-1)
  { free(buf); free(log_name); return; }
  
  
  index_name=eb_get_value(c->config_key, "log_index");
  if(index_name[0]=='\0')
  {
    index_name=eb_get_filename("logs");
    eb_put_value(c->config_key, "log_index", index_name);
  } else {
    index_name=strdup(index_name);
  }
  
  if((fd[0]=open(index_name, O_WRONLY|O_CREAT|O_APPEND, 00600))<0)
  { free(buf); free(log_name); free(index_name); perror("Contact index open failed"); return; }
  free(index_name);
  strcpy(buf, eb_config_dir);
  strcat(buf, "logindex");
  if((fd[1]=open(buf, O_WRONLY|O_CREAT|O_APPEND, 00600))<0)
  { free(buf); free(log_name); perror("Master index open failed"); return; }

  for(a=0; a<2; a++)
  {
    char ch='c';
    ewrite(fd[a], &ch, 1);
    ewrite(fd[a], &benow, 4);

    eb_write_log_string(fd[a], c->group->name);
    eb_write_log_string(fd[a], c->name);
    
    eb_write_log_string(fd[a], log_name+strlen(eb_config_dir));
  }
  
  close(fd[0]);
  close(fd[1]);

  c->log_begins=now;
  
  eb_open_logs_c=e_list_append(eb_open_logs_c, c);
  // TODO - schedule cleanups here
  
  free(buf);
  free(log_name);
  
  printf("Opened logfile for contact %s\n", c->name);
  
  if(!cleanup_timer_set)
  {
    printf("Setting cleanup timer\n");
    eb_set_timer(chat_log_checker, 15*60, NULL);
    cleanup_timer_set=1;
  }
}

void eb_log_message(int fd, time_t when, char * user, char * service, char direction, char * msg)
{
  uint32_t nwhen=htonl(when);
  printf("Log message: %d chars\n", strlen(msg));
  printf("From/to \"%s\" (\"%s\")\n%s\n", user, service, msg);
  
  ewrite(fd, &direction, 1);
  ewrite(fd, &nwhen, 4);
  eb_write_log_string(fd, user);
  eb_write_log_string(fd, service);
  eb_write_long_log_string(fd, msg);
  
  printf("Logged message OK.\n");
}

void eb_incoming_message(eb_account * remote, char * omessage)
{
  time_t now=time(NULL);
  eb_html_item * message;

  if(remote->contact->ignore!=NULL)
  {
    if(remote->contact->next_away_msg>now) { return; }

    if(remote->buddy_of->service->sc->send_im==NULL) { return; }

    if(remote->contact->ignore[0]!='\0')
    {
      char header[]="Your messages are being ignored: ";
      char * msg=(char *)malloc(strlen(header)+strlen(remote->contact->ignore)+1);
      strcpy(msg, header);
      strcat(msg, remote->contact->ignore);
      msg=remote->buddy_of->service->sc->send_im(remote, msg);
      // do NOT acknowledge this with eb_sent_message(), otherwise we lose the whole point...
      remote->contact->next_away_msg=now+600;
      if(msg!=NULL) { free(msg); }
    }

    return;
  }

  omessage=strdup(omessage);
  omessage=eb_filter_string(EB_POSTNOTIFY_IN, omessage, remote);
  if(omessage==NULL) { return; }
  message=eb_html_parse(omessage);
  free(omessage);
  
  if(eb_get_value(registry, "config/log_conversations")[0]=='1' || remote->contact->logfile>0)
  {
    eb_open_contact_logfile(remote->contact);
    if(remote->contact->logfile>0)
    {
      char * rendered=eb_html_render(message);
      time_t now=time(NULL);
      time_t when=now-remote->contact->log_begins;
      printf("Recv msg log\n");
      eb_log_message(remote->contact->logfile, when, remote->handle, remote->buddy_of->service_name, 'R', rendered);
      printf("Received message logged\n");
      remote->contact->last_message=now;
      free(rendered);
    }
  }

  if(eb_holding_messages)
  {
    eb_held_message * msg=(eb_held_message *)malloc(sizeof(eb_held_message));
    msg->buddy=remote;
    msg->contact=NULL;
    msg->message=message;
    msg->when=time(NULL);
    msg->direction=EB_MSG_RECV;
    remote->locked++;

    NOTIFY_HELD();
    eb_held_messages=e_list_append(eb_held_messages, msg);
  } else {
    eb_gui_got_message(remote, message);
    eb_html_destroy(message);
  }
  
  if(away_short!=NULL)
  {
    if(remote->contact->next_away_msg<now)
    {
      char * away_sent;

      remote->contact->next_away_msg=now+300;
      if(remote->buddy_of->service->sc->send_im==NULL) { return; }

      away_sent=remote->buddy_of->service->sc->send_im(remote, eb_prepare_away_msg());
      if(away_sent==NULL) { return; }

      eb_sent_message(remote, away_sent);

      free(away_sent);
    }
  }
}

char * eb_prepare_away_msg(void)
{
  int len=0, a, b;
  char * msg;
  
  printf("Preparing a message\n");
  
  for(a=0; away_msg[a]!='\0'; a++)
  {
    if(away_msg[a]=='%')
    {
      switch(away_msg[a+1])
      {
        case('t') : { len+=16; break; }
      }
    }
    len++;
  }
  
  msg=(char *)malloc(len+1);
  
  for(a=0, b=0; away_msg[a]!='\0'; a++)
  {
    if(away_msg[a]=='%')
    {
      switch(away_msg[a+1])
      {
        case('t') : {
	  time_t now=time(NULL);
	  struct tm * tv=localtime(&now);
	  
	  b+=sprintf(msg+b, "%d:%02d", tv->tm_hour, tv->tm_min);
	  a++;
	  continue;
	}
	
	case('%') : { a++; }
      }
    }
    
    msg[b++]=away_msg[a];
  }
  msg[b]='\0';
  
  return msg;
}

void eb_notify_3rdperson(eb_contact * contact, char * omessage)
{
  eb_html_item * message;
  if(contact->ignore!=NULL) { return; }

  message=eb_html_parse(omessage);
  
  if(eb_get_value(registry, "config/log_conversations")[0]=='1' || contact->logfile>0)
  {
    eb_open_contact_logfile(contact);
    if(contact->logfile>0)
    {
      char * rendered=eb_html_render(message);
      time_t now=time(NULL);
      time_t when=now-contact->log_begins;
      printf("Third-person log\n");
      eb_log_message(contact->logfile, when, "", "", '3', rendered);
      printf("3PL OK\n");
      contact->last_message=now;
      free(rendered);
    }
  }
  
  
  if(eb_holding_messages)
  {
    eb_held_message * msg=(eb_held_message *)malloc(sizeof(eb_held_message));
    msg->buddy=NULL;
    msg->contact=contact;
    msg->message=message;
    msg->when=time(NULL);
    msg->direction=EB_MSG_3RDPERSON;
    contact->locked++;

    NOTIFY_HELD();
    eb_held_messages=e_list_append(eb_held_messages, msg);
  } else {
    eb_gui_notify_3rdperson(contact, message);
    eb_html_destroy(message);
  }
}

void eb_sent_message(eb_account * remote, char * omessage)
{
  eb_html_item * message=eb_html_parse(omessage);
  
  if(eb_get_value(registry, "config/log_conversations")[0]=='1' || remote->contact->logfile>0)
  {
    eb_open_contact_logfile(remote->contact);
    if(remote->contact->logfile>0)
    {
      char * rendered=eb_html_render(message);
      time_t now=time(NULL);
      time_t when=now-remote->contact->log_begins;
      printf("Log: sending message\n");
      eb_log_message(remote->contact->logfile, when, remote->buddy_of->handle, remote->buddy_of->service_name, 'S', rendered);
      printf("Sent message logged\n");
      remote->contact->last_message=now;
      free(rendered);
    }
  }
  
  if(eb_holding_messages)
  {
    eb_held_message * msg=(eb_held_message *)malloc(sizeof(eb_held_message));
    msg->buddy=remote;
    msg->contact=NULL;
    msg->message=message;
    msg->when=time(NULL);
    msg->direction=EB_MSG_SEND;
    remote->locked++;

    NOTIFY_HELD();
    eb_held_messages=e_list_append(eb_held_messages, msg);
  } else {
    eb_gui_sent_message(remote, message);
    eb_html_destroy(message);
  }
}


void eb_incoming_data_message(eb_account * remote, char * filename, char * contenttype, char * disposition, char * suggested_filename, int length)
{
  if(!strcmp(disposition, "inline"))
  {
    if(eb_holding_messages)
    {
      eb_held_message * msg=(eb_held_message *)malloc(sizeof(eb_held_message));
      msg->buddy=remote;
      msg->contact=NULL;
      msg->contenttype=strdup(contenttype);
      msg->filename=strdup(filename);
      msg->when=time(NULL);
      msg->direction=EB_MSG_INLINE_RECV;
      remote->locked++;
    
      NOTIFY_HELD();
      eb_held_messages=e_list_append(eb_held_messages, msg);
    } else {
      eb_gui_data_message(remote, filename, contenttype, disposition, suggested_filename, length, EB_MSG_INLINE_RECV, 0);
    }
  } else {
    printf("FIXME: Do something with the normal message type \"%s\" [%s]", contenttype, disposition);
  }
}

void eb_sent_inline_data_message(eb_account * remote, char * filename, char * contenttype)
{
  if(eb_holding_messages)
  {
    eb_held_message * msg=(eb_held_message *)malloc(sizeof(eb_held_message));
    msg->buddy=remote;
    msg->contact=NULL;
    msg->contenttype=strdup(contenttype);
    msg->filename=strdup(filename);
    msg->when=time(NULL);
    msg->direction=EB_MSG_INLINE_SEND;
    remote->locked++;
    
    NOTIFY_HELD();
    eb_held_messages=e_list_append(eb_held_messages, msg);
  } else {
    eb_gui_data_message(remote, filename, contenttype, "inline", "", 0, EB_MSG_INLINE_SEND, 0);
  }
}

void eb_destroy_inlined_data_state(eb_inlined_data_state * ids)
{
  int a;
  if(ids==NULL) { return; }
  for(a=0; a<5; a++)
  { if(ids->buf[a]!=NULL) { free(ids->buf[a]); } }
  free(ids);
}


int eb_handle_inlined_data(eb_account * acc, char * msg, int msglen, eb_inlined_data_state ** idsp)
{
  int minlen;
  int a, index, ctlen;
  char contenttype[256];
  eb_inlined_data_state * ids;

  if(msglen<9) { return 1; }
  minlen=9+msg[8]-'a';
  index=msg[6]-'a';
  ctlen=msg[8]-'a';
  if(minlen<9 || msglen<minlen || index>=5) { return 1; }
    
  if(*idsp==NULL)
  { *idsp=(eb_inlined_data_state *)calloc(1, sizeof(eb_inlined_data_state)); }
  ids=*idsp;
  
  strncpy(contenttype, msg+9, ctlen);
  
  for(a=0; a<index; a++)
  { if(ids->buf[a]==NULL) { printf("Dropped malindexed inline data\n"); } }
  
  if(ids->buf[index]!=NULL) { free(ids->buf); }
  
  ids->buf[index]=strdup(msg+9+ctlen);
  
  ids->lengths[index]=decode_base64(ids->buf[index], strlen(ids->buf[index]));

  if(ids->lengths[index]==0)
  { printf("Invalid base64 data\n"); return; }
  
  if(msg[7]=='X') // flag finished
  {
    char * filename=eb_get_filename("tmp");
    FILE * dat=fopen(filename, "w");
    int a;
    
    for(a=0; a<=index; a++)
    { fwrite(ids->buf[a], ids->lengths[a], 1, dat); }
    
    fclose(dat);
    
    eb_incoming_data_message(acc, filename, contenttype, "inline", "", 0);
    
    free(filename);
  }
  
  return 0;
}


void eb_package_inlined_data(char * filename, char * contenttype, int length, int max_msg_len, char ** buf, int * num_msgs)
{
  FILE * dat=fopen(filename, "r");
  int chunksize, a;
  int ctlen=strlen(contenttype);
  char * tbuf;
  
  for(*num_msgs=1; (*num_msgs)<5; (*num_msgs)++) // Yes, that < is deliberate, so we default to 5
  {
    if(length-(*num_msgs-1)*length/(*num_msgs) < (max_msg_len-32)*3/4)
    { break; }
  }
  
  chunksize=length/(*num_msgs);
  tbuf=(char *)malloc(chunksize+10);
  
  for(a=0; a<*num_msgs; a++)
  {
    int size=(a<*num_msgs-1)?(chunksize):(chunksize+length%chunksize);
    fread(tbuf, 1, size, dat);
    sprintf(buf[a], "EB+]#[%c%c%c%s", a+'a', (a==(*num_msgs)-1)?('X'):(' '), ctlen+'a', contenttype);
    encode_base64(buf[a]+9+strlen(contenttype), tbuf, size);
  }
  
  free(tbuf);
  fclose(dat);
}




// Filter chain manipulation
// call a filter chain on a string - this string may be free()ed by those functions
char * eb_filter_string(int chain_id, char * string, void * context)
{
  char * s=string;
  EList * n;

  for(n=eb_filters[chain_id]; n!=NULL; n=n->next)
  {
    eb_filter * tf=(eb_filter *)n->data;

    s=tf->func(s, context);
    if(s==NULL) { return NULL; }
  }

  return s;
}

// Add a filter to chain
void eb_add_filter(int chain_id, eb_filter_func func, int priority)
{
  eb_filter * filter=(eb_filter *)malloc(sizeof(eb_filter));
  EList * n;

  filter->func=func;
  filter->priority=priority;

  for(n=eb_filters[chain_id]; n!=NULL; n=n->next)
  {
    eb_filter * tf=(eb_filter *)n->data;

    if(tf->priority>priority)
    { eb_filters[chain_id]=e_list_insert(eb_filters[chain_id], n, filter); return; }
  }

  // if we got this far, this is the highest-priority link in the chain (ie executed last)

  eb_filters[chain_id]=e_list_append(eb_filters[chain_id], filter);
}

// Remove a filter from a chain
void eb_del_filter(int chain_id, eb_filter_func func)
{
  EList * n;

  for(n=eb_filters[chain_id]; n!=NULL; n=n->next)
  {
    eb_filter * tf=(eb_filter *)n->data;

    if(tf->func==func)
    {
      eb_filters[chain_id]=e_list_remove_link(eb_filters[chain_id], n);
      e_list_free_1(n);
      free(tf);
      return;
    }
  }

  eb_debug(DBG_CORE, "Cannot find filter to delete!\n");
}

