/***************************************************************************
                    main.c - main(), and not a lot else
                             -------------------
                     (C) 2002 by the Everybuddy team
                            www.everybuddy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>

#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/unistd.h>

#include "elist.h"

#include "globals.h"
#include "plugin.h"
#include "gui_comms.h"
#include "prefs.h"
#include "accounts.h"
#include "contactlist.h"
#include "util.h"

#define FORCE_NEW_PLUGINS_DIR
#ifndef PLUGINS_DIR
/* Makefile should everride this */
# define PLUGINS_DIR "/usr/local/lib/eb-lite"
#endif
#ifndef OLD_PLUGINS_DIR
# define OLD_PLUGINS_DIR "/usr/local/share/eb-lite/plugins"
#endif

//#ifndef VERSION
#define VERSION "EB-lite alpha-13"
//#endif

int main(int argc, char * argv[])
{
  int gui_port=18234;
  char * tmp;
  int a;

#ifndef __MINGW32__
  signal(SIGPIPE, SIG_IGN);
#endif

  srand(time(NULL));
  for(a=0; a<8; a++)
  { eb_authcookie[a]=(unsigned char)((256.0*rand())/RAND_MAX); }

  for(a=1; a<argc; a++)
  {
    if(!strcmp(argv[a], "-p") || !strcmp(argv[a], "--port"))
    {
      if(a+1==argc)
      { printf("-p/--port option requires an argument - use --help for usage\n"); exit(1); }
      gui_port=atoi(argv[++a]);
      if(gui_port==0)
      {
        printf("\"%s\" is not a valid TCP port number\n", argv[a]);
        exit(1);
      }
      continue;
    }

    if(!strcmp(argv[a], "-n") || !strcmp(argv[a], "--nobind"))
    {
      gui_port=0;
      eb_quit_on_last=1;
      continue;
    }

    if(!strcmp(argv[a], "-q") || !strcmp(argv[a], "--quit-on-last"))
    {
      eb_quit_on_last=1;
      continue;
    }

    if(!strcmp(argv[a], "-d") || !strcmp(argv[a], "--config-dir"))
    {
      struct stat s_info;

      if(a+1==argc)
      { printf("-d/--config-dir option requires an argument - use --help for usage\n"); exit(1); }

      if(eb_config_dir!=NULL) { free(eb_config_dir); } // Why did they use -d twice? *shrug*
      eb_config_dir=(char *)malloc(strlen(argv[++a])+2);

      strcpy(eb_config_dir, argv[a]);
      if(eb_config_dir[strlen(eb_config_dir)-1]!='/')
      {
        strcat(eb_config_dir, "/");
      }

      if(stat(eb_config_dir, &s_info)==-1)
      { perror(argv[a]); exit(1); }

      if(!S_ISDIR(s_info.st_mode))
      { fprintf(stderr, "%s is not a directory\n", eb_config_dir); exit(1); }

      continue;
    }

    if(!strcmp(argv[a], "-c") || !strcmp(argv[a], "--cookie"))
    {
      int i;

      if(a+8>=argc)
      { printf("-c/--cookie option takes 8 arguments. Use --help for details\n"); exit(1); }

      for(i=0; i<8; i++)
      {
        eb_authcookie[i]=atoi(argv[++a]);
      }

      continue;
    }

    if(!strcmp(argv[a], "-f") || !strcmp(argv[a], "--pipes"))
    {
      int p1, p2;
      eb_gui * gui;

      if(a+2>=argc)
      { printf("-f/--pipes option requires two arguments - use --help for usage\n"); exit(1); }

      p1=atoi(argv[++a]);
      p2=atoi(argv[++a]);

      if(p1==0 || p2==0)
      { printf("Invalid file descriptors for -f/--pipes\n"); exit(1); }

      gui=(eb_gui *)malloc(sizeof(eb_gui));
      GUIs=e_list_append(GUIs, gui);
      gui->num_params=0;
      gui->params=NULL;
      gui->cookie_progress=8; // bypass cookie
      gui->read_fd=p1;
      gui->write_fd=p2;
      gui->html=1;

      gui->tag=eb_input_add(p1, EB_INPUT_READ | EB_INPUT_EXCEPTION, eb_gui_incoming, gui);
      continue;
    }

    if(!strcmp(argv[a], "-v") || !strcmp(argv[a], "--version"))
    {
      printf(VERSION "\t\t(c) 2002-2004 Everybuddy team\n\n"
       "\tEverybuddy is an instant messenger client designed to be compatible\n"
       "with all major instant messaging systems. It is brought to you by the\n"
       "contributions of:\n\t"
       "Meredydd Luff\t-- Lead developer, MSN\n\t"
       "Chris Boyle\t-- EbQt\n\t"
       "Karine Proot\t-- ebnc\n\t"
       "Cory McWilliams\t-- IRC, Jabber\n\t"
       "Craig West\t-- Yahoo\n\t"
       "Rodney Dawes\t-- Build system\n\t"
       "Philip Tellis\t-- Yahoo (library)\n\t"
       "Torrey Searle\t-- AIM (library)\n\n"
       "Visit the website at http://www.everybuddy.com/eb-lite\n");

      exit(0);
    }

    // if we got here, it's unrecognised
    if(strcmp(argv[a], "--help") && strcmp(argv[a], "-h"))
    { printf("Unrecognised command-line flag: %s\n\n", argv[a]); }

    printf("Usage: %s <options>\nOptions:\n"
     "  --version, -v\n\tPrints version and copyright information and exits successfully\n"
     "  --help, -h\n\tPrints this message and exits successfully\n"
     "  --port N, -p N\n\tListen for UI connections on TCP port N. Defaults to 18234\n"
     "  --cookie C1...C8, -c C1...C8\n\tForce the UI auth cookie to be the eight bytes C1...C8, rather\n\tthan randomising it\n"
     "  --pipes IN OUT, -f IN OUT\n\tStart out with a user interface connected to this\n\tpair of file descriptors (IN for reading, OUT for writing). Mostly used\n\t(with --nobind) for automated \"warm starts\" of the core. May be\n\tused more than once for different UIs, IN and OUT may be the same\n"
     "  --nobind, -n\n\tDo not listen for TCP connections. Implies --quit-on-last,\n\trequires --pipes\n"
     "  --quit-on-last, -q\n\tQuit as soon as the last user interface disconnects. Exits\n\timmediately without --pipes\n"
     "  --config-dir DIR, -d DIR\n\tRead and store configuration information in the directory DIR\n\tDefaults to ~/.everybuddy/\n\n",
       argv[0]);

    exit(1);
  }

  if(eb_config_dir==NULL)
  {
    char * homedir=getenv("HOME");
    if(homedir==NULL)
    {
      homedir="";
    }
    eb_config_dir=(char *)malloc(strlen(homedir)+15);
    strcpy(eb_config_dir, homedir);
    strcat(eb_config_dir, "/.everybuddy/");
    mkdir(eb_config_dir, 0700);
  }

  tmp=(char *)malloc(strlen(eb_config_dir)+20);
  strcpy(tmp, eb_config_dir);
  strcat(tmp, "everybuddy.conf");
  eb_load_key(registry, tmp);
  free(tmp);

  prefs_init();
  plugins_init();

  eb_put_default(registry, "config/plugin_dir", PLUGINS_DIR);
#ifdef FORCE_NEW_PLUGINS_DIR
  if (!strcmp(eb_get_value(registry, "config/plugin_dir"), OLD_PLUGINS_DIR))
  {
    // For now, force the new plugin location
    // We should remove this code once we have some expectation that the user
    // might have changed it, but right now they won't have done that, anyways
    eb_put_value(registry, "config/plugin_dir", PLUGINS_DIR);
  }
#endif /* FORCE_NEW_PLUGINS_DIR */

  load_local_accounts();
  load_plugins(eb_get_value(registry, "config/plugin_dir"));
  load_contact_list();
  eb_register_misc_cb();

  if(gui_port!=0)
  {
    eb_gui_comms_init(gui_port);
    for(a=0; a<8; a++)
    { fprintf(stderr, "%d ", eb_authcookie[a]); }
    fprintf(stderr, "\n");
  }

  if(GUIs==NULL)
  {
    if(gui_port==0)
    { printf("No binding requested but -f/--pipes not specified, exiting. Use --help for usage.\n"); exit(0); }
    eb_set_away("Nobody home", "This is an automated message. The user you are addressing is probably away from their computer. Your message will be displayed when they return.");
  } else {
    EList * n;
    for(n=GUIs; n!=NULL; n=n->next)
    {
      eb_gui * gui=(eb_gui *)n->data;
      eb_gui_welcome(gui);
    }
  }

  if(strcmp(eb_get_value(registry, "config/version"), VERSION))
  {
    printf("Upgrade/install gubbins\n");
    eb_show_yesno_dialog("It looks like you've just installed or upgraded Everybuddy.\n\nWe'd like to know how many people are using it - it's easy, all you need to\ndo is click Yes below to send us a small message telling us which version\nyou're using, and (if applicable) what you upgraded from.\n\nTransmit this information?", "Upgrade", 1, eb_phonehome_cb, strdup(VERSION));
  }
  
  while(1)
  {
    eb_polling_loop();
  }
}
